/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.components;

import com.flipper.models.Transaction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collections;
import java.util.List;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.DimmableJPanel;

public class AmountProgressBar
extends DimmableJPanel {
    private int maximumValue;
    private int value;
    private List<Integer> positions = Collections.emptyList();

    public AmountProgressBar(Transaction transaction) {
        this.setLayout(new BorderLayout());
        this.maximumValue = transaction.getTotalQuantity();
        this.value = transaction.getQuantity();
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setForeground(Color.GREEN.darker().darker());
        this.setPreferredSize(new Dimension(100, 4));
    }

    public void paint(Graphics g) {
        int percentage = this.getPercentage();
        int topWidth = (int)((float)this.getSize().width * ((float)percentage / 100.0f));
        super.paint(g);
        g.setColor(this.getForeground());
        g.fillRect(0, 0, topWidth, 4);
        for (Integer position : this.positions) {
            int xCord = this.getSize().width * position / this.maximumValue;
            if (xCord <= topWidth) continue;
            g.fillRect(xCord, 0, 1, 4);
        }
        super.paintComponents(g);
    }

    private int getPercentage() {
        if (this.value == 0) {
            return 0;
        }
        return this.value * 100 / this.maximumValue;
    }
}

