/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.alchs;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.Timestamps;
import com.flipper.helpers.UiUtilities;
import com.flipper.models.Alch;
import com.flipper.views.components.DeleteButton;
import com.flipper.views.components.ItemHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class AlchPanel
extends JPanel {
    private Alch alch;
    private static int LABEL_COUNT = 7;
    private JPanel container = new JPanel();
    private JPanel itemInfo = new JPanel(new BorderLayout());
    private JPanel leftInfoTextPanel = new JPanel(new GridLayout(LABEL_COUNT, 1));
    private JPanel rightValuesPanel = new JPanel(new GridLayout(LABEL_COUNT, 1));

    public AlchPanel(Alch alch, ItemManager itemManager, Consumer<UUID> removeAlchConsumer, boolean isPrompt) {
        this.alch = alch;
        ItemComposition itemComp = itemManager.getItemComposition(alch.getItemId());
        DeleteButton deleteAlchButton = new DeleteButton(action -> {
            int input;
            String describedAlch = alch.describeAlch(itemComp.getName());
            int n = input = isPrompt ? JOptionPane.showConfirmDialog(null, "Delete alch of " + describedAlch + "?") : 0;
            if (input == 0) {
                removeAlchConsumer.accept(alch.getId());
                this.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        this.container.setLayout(new BorderLayout());
        this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.container.add((Component)new ItemHeader(alch.getItemId(), 0, itemComp.getName(), itemManager, false, deleteAlchButton), "North");
        this.constructItemInfo();
        this.setBorder(new EmptyBorder(0, 5, 3, 5));
        this.add((Component)this.container, "North");
    }

    public void constructItemInfo() {
        this.constructLeftLabels();
        this.constructRightLabels();
        this.itemInfo.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemInfo.add((Component)this.leftInfoTextPanel, "West");
        this.itemInfo.add((Component)this.rightValuesPanel, "East");
        this.itemInfo.setBorder(UiUtilities.ITEM_INFO_BORDER);
        this.container.add((Component)this.itemInfo, "Center");
    }

    private JLabel newLeftLabel(String text) {
        JLabel newJLabel = new JLabel(text);
        newJLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        newJLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newJLabel;
    }

    private void addLeftLabel(JLabel newLeftLabel) {
        this.leftInfoTextPanel.add(newLeftLabel);
    }

    private void constructLeftLabels() {
        this.leftInfoTextPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JLabel quantityLabel = this.newLeftLabel("Quantity:");
        JLabel profitEachLabel = this.newLeftLabel("Profit Per:");
        JLabel totalProfitLabel = this.newLeftLabel("Total Profit:");
        JLabel buyPrice = this.newLeftLabel("Buy Price:");
        JLabel alchPrice = this.newLeftLabel("Alch Price:");
        JLabel natureRunePrice = this.newLeftLabel("Nature Rune:");
        JLabel alchLastUpdatedAt = this.newLeftLabel("Date:");
        this.addLeftLabel(quantityLabel);
        this.addLeftLabel(profitEachLabel);
        this.addLeftLabel(totalProfitLabel);
        this.addLeftLabel(buyPrice);
        this.addLeftLabel(alchPrice);
        this.addLeftLabel(natureRunePrice);
        this.addLeftLabel(alchLastUpdatedAt);
        this.leftInfoTextPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }

    private JLabel newRightLabel(String value, Color fontColor) {
        JLabel newRightLabel = new JLabel(value);
        newRightLabel.setHorizontalAlignment(4);
        newRightLabel.setForeground(fontColor);
        newRightLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        return newRightLabel;
    }

    private void addRightLabel(JLabel newRightLabel) {
        this.rightValuesPanel.add(newRightLabel);
    }

    private void constructRightLabels() {
        this.rightValuesPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        int totalProfit = this.alch.getTotalProfit();
        int quantity = this.alch.getQuantity();
        int profitEach = quantity != 0 ? this.alch.getAlchPrice() - this.alch.getBuyPrice() - this.alch.getNatureRunePrice() : 0;
        String quantityText = Integer.toString(this.alch.getQuantity());
        String totalProfitText = Integer.toString(totalProfit);
        String profitEachText = Integer.toString(profitEach);
        JLabel quantityLabel = this.newRightLabel(Numbers.numberWithCommas(quantityText), ColorScheme.GRAND_EXCHANGE_ALCH);
        Color profitEachColor = profitEach > 0 ? ColorScheme.GRAND_EXCHANGE_ALCH : ColorScheme.PROGRESS_ERROR_COLOR;
        JLabel profitEachLabel = this.newRightLabel(Numbers.numberWithCommas(profitEachText), profitEachColor);
        Color profitColor = this.alch.getTotalProfit() > 0 ? ColorScheme.GRAND_EXCHANGE_ALCH : ColorScheme.PROGRESS_ERROR_COLOR;
        JLabel totalProfitLabel = this.newRightLabel(Numbers.numberWithCommas(totalProfitText), profitColor);
        JLabel buyPrice = this.newRightLabel(Numbers.numberWithCommas(this.alch.getBuyPrice()), ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel alchPrice = this.newRightLabel(Numbers.numberWithCommas(this.alch.getAlchPrice()), ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel alchCreatedAt = this.newRightLabel(Timestamps.format(this.alch.getCreatedAt()), ColorScheme.GRAND_EXCHANGE_ALCH);
        JLabel natureRunePrice = this.newRightLabel(String.valueOf(this.alch.natureRunePrice), ColorScheme.GRAND_EXCHANGE_ALCH);
        this.addRightLabel(quantityLabel);
        this.addRightLabel(profitEachLabel);
        this.addRightLabel(totalProfitLabel);
        this.addRightLabel(buyPrice);
        this.addRightLabel(alchPrice);
        this.addRightLabel(natureRunePrice);
        this.addRightLabel(alchCreatedAt);
        this.rightValuesPanel.setBorder(new EmptyBorder(2, 5, 2, 10));
    }
}

