/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.views.alchs;

import com.flipper.helpers.Numbers;
import com.flipper.helpers.UiUtilities;
import com.flipper.views.alchs.AlchPanel;
import com.flipper.views.components.SearchBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class AlchPage
extends JPanel {
    private JPanel container;
    private JLabel totalProfitValueLabel;
    private Runnable refreshAlchsRunnable;
    private Consumer<String> onSearchTextChanged;

    public AlchPage(Runnable refreshAlchsRunnable, Consumer<String> onSearchTextChanged) {
        this.refreshAlchsRunnable = refreshAlchsRunnable;
        this.onSearchTextChanged = onSearchTextChanged;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.build();
    }

    public void addAlchPanel(AlchPanel alchPanel) {
        this.container.add((Component)alchPanel, "Center");
        this.revalidate();
    }

    public void resetContainer() {
        this.container.removeAll();
    }

    public void constructTotalProfit(String totalProfit) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JPanel totalProfitContainer = new JPanel(new GridLayout(2, 1));
        JPanel totalProfitHeader = new JPanel();
        JLabel totalProfitLabel = new JLabel("Alch Profit");
        totalProfitLabel.setFont(new Font(FontManager.getRunescapeBoldFont().getName(), FontManager.getRunescapeBoldFont().getStyle(), 16));
        totalProfitLabel.setHorizontalAlignment(0);
        totalProfitLabel.setForeground(Color.WHITE);
        ImageIcon refreshIcon = new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"/refresh.png"));
        JLabel refreshFlips = new JLabel();
        refreshFlips.setToolTipText("Refresh alchs");
        refreshFlips.setIcon(refreshIcon);
        refreshFlips.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    AlchPage.this.refreshAlchsRunnable.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        totalProfitHeader.add(totalProfitLabel);
        totalProfitHeader.add(refreshFlips);
        this.totalProfitValueLabel = new JLabel("0");
        this.totalProfitValueLabel.setFont(new Font(FontManager.getRunescapeFont().getName(), FontManager.getRunescapeFont().getStyle(), 24));
        this.totalProfitValueLabel.setHorizontalAlignment(0);
        Color totalProfitColor = ColorScheme.GRAND_EXCHANGE_ALCH;
        this.totalProfitValueLabel.setForeground(totalProfitColor);
        totalProfitContainer.add(totalProfitHeader);
        totalProfitContainer.add(this.totalProfitValueLabel);
        totalProfitContainer.setBorder(UiUtilities.ITEM_INFO_BORDER);
        container.add((Component)totalProfitContainer, "North");
        SearchBar searchBar = new SearchBar(this.onSearchTextChanged);
        container.add((Component)searchBar, "South");
        container.setBorder(new EmptyBorder(0, 0, 3, 0));
        this.add((Component)container, "North");
    }

    public void setTotalProfit(String totalProfit) {
        this.totalProfitValueLabel.setText(Numbers.numberWithCommas(totalProfit));
    }

    public void build() {
        this.constructTotalProfit("0");
        JPanel scrollContainer = new JPanel();
        scrollContainer.setLayout(new BorderLayout());
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 3));
        this.container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JScrollPane scrollPane = new JScrollPane(scrollContainer);
        scrollPane.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollContainer.add((Component)this.container, "First");
        this.add((Component)scrollPane, "Center");
    }
}

