/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.models;

import com.flipper.helpers.GrandExchange;
import java.time.Instant;
import java.util.UUID;
import net.runelite.api.GrandExchangeOffer;

public class Transaction {
    public final UUID id = UUID.randomUUID();
    private int quantity;
    private int totalQuantity;
    private int itemId;
    private int pricePer;
    private int slot;
    private String itemName;
    private boolean isBuy;
    private boolean isComplete;
    private boolean isFlipped;
    private boolean isAlched;
    private Instant completedTime;
    private Instant createdTime;
    private boolean hasCancelledOnce = false;

    public Transaction(int quantity, int totalQuantity, int itemId, int pricePer, int slot, String itemName, boolean isBuy, boolean isComplete) {
        this.quantity = quantity;
        this.totalQuantity = totalQuantity;
        this.itemId = itemId;
        this.pricePer = pricePer;
        this.slot = slot;
        this.itemName = itemName;
        this.isBuy = isBuy;
        this.isComplete = isComplete;
        this.createdTime = Instant.now();
        this.isFlipped = false;
        this.hasCancelledOnce = false;
    }

    public Transaction updateTransaction(GrandExchangeOffer offer) {
        this.quantity = offer.getQuantitySold();
        this.totalQuantity = offer.getTotalQuantity();
        this.pricePer = offer.getSpent() / offer.getQuantitySold();
        boolean isCancelState = GrandExchange.checkIsCancelState(offer.getState());
        if (!isCancelState || this.hasCancelledOnce && isCancelState) {
            this.isComplete = GrandExchange.checkIsComplete(offer.getState());
        }
        if (isCancelState) {
            this.hasCancelledOnce = true;
        }
        if (this.isComplete) {
            this.completedTime = Instant.now();
            this.totalQuantity = offer.getQuantitySold();
        }
        return this;
    }

    public String describeTransaction() {
        return String.valueOf(this.quantity) + " " + this.itemName + "(s)";
    }

    public void setIsFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public int getTotalPrice() {
        return this.pricePer * this.quantity;
    }

    public boolean isFilled() {
        return this.quantity == this.totalQuantity;
    }

    public UUID getId() {
        return this.id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getTotalQuantity() {
        return this.totalQuantity;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getPricePer() {
        return this.pricePer;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getItemName() {
        return this.itemName;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public boolean isAlched() {
        return this.isAlched;
    }

    public Instant getCompletedTime() {
        return this.completedTime;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public boolean isHasCancelledOnce() {
        return this.hasCancelledOnce;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setTotalQuantity(int totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setPricePer(int pricePer) {
        this.pricePer = pricePer;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setBuy(boolean isBuy) {
        this.isBuy = isBuy;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public void setAlched(boolean isAlched) {
        this.isAlched = isAlched;
    }

    public void setCompletedTime(Instant completedTime) {
        this.completedTime = completedTime;
    }

    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    public void setHasCancelledOnce(boolean hasCancelledOnce) {
        this.hasCancelledOnce = hasCancelledOnce;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        if (this.getQuantity() != other.getQuantity()) {
            return false;
        }
        if (this.getTotalQuantity() != other.getTotalQuantity()) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        if (this.getPricePer() != other.getPricePer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        if (this.isBuy() != other.isBuy()) {
            return false;
        }
        if (this.isComplete() != other.isComplete()) {
            return false;
        }
        if (this.isFlipped() != other.isFlipped()) {
            return false;
        }
        if (this.isAlched() != other.isAlched()) {
            return false;
        }
        Instant this$completedTime = this.getCompletedTime();
        Instant other$completedTime = other.getCompletedTime();
        if (this$completedTime == null ? other$completedTime != null : !((Object)this$completedTime).equals(other$completedTime)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        return this.isHasCancelledOnce() == other.isHasCancelledOnce();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        result = result * 59 + this.getQuantity();
        result = result * 59 + this.getTotalQuantity();
        result = result * 59 + this.getItemId();
        result = result * 59 + this.getPricePer();
        result = result * 59 + this.getSlot();
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        result = result * 59 + (this.isBuy() ? 79 : 97);
        result = result * 59 + (this.isComplete() ? 79 : 97);
        result = result * 59 + (this.isFlipped() ? 79 : 97);
        result = result * 59 + (this.isAlched() ? 79 : 97);
        Instant $completedTime = this.getCompletedTime();
        result = result * 59 + ($completedTime == null ? 43 : ((Object)$completedTime).hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        result = result * 59 + (this.isHasCancelledOnce() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Transaction(id=" + this.getId() + ", quantity=" + this.getQuantity() + ", totalQuantity=" + this.getTotalQuantity() + ", itemId=" + this.getItemId() + ", pricePer=" + this.getPricePer() + ", slot=" + this.getSlot() + ", itemName=" + this.getItemName() + ", isBuy=" + this.isBuy() + ", isComplete=" + this.isComplete() + ", isFlipped=" + this.isFlipped() + ", isAlched=" + this.isAlched() + ", completedTime=" + this.getCompletedTime() + ", createdTime=" + this.getCreatedTime() + ", hasCancelledOnce=" + this.isHasCancelledOnce() + ")";
    }
}

