/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.models;

import com.flipper.models.Transaction;
import java.sql.Timestamp;
import java.util.UUID;

public class Flip {
    public UUID id;
    public UUID userId;
    public UUID buyId;
    public UUID sellId;
    public int itemId;
    public int quantity;
    public int buyPrice;
    public int sellPrice;
    private Timestamp updatedAt;
    private Timestamp createdAt;

    public Flip() {
    }

    public Flip(Transaction buy, Transaction sell) {
        this.buyId = buy.id;
        this.sellId = sell.id;
        this.itemId = sell.getItemId();
        this.quantity = sell.getQuantity();
        this.buyPrice = buy.getPricePer();
        this.sellPrice = sell.getPricePer();
        this.updatedAt = new Timestamp(System.currentTimeMillis());
        this.createdAt = new Timestamp(System.currentTimeMillis());
    }

    public boolean isMarginCheck() {
        return this.quantity == 1 && this.buyPrice >= this.sellPrice;
    }

    public String describeFlip(String itemName) {
        return String.valueOf(this.quantity) + " " + itemName + "(s)";
    }

    public int getTotalProfit() {
        return (this.sellPrice - this.buyPrice) * this.quantity;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public UUID getBuyId() {
        return this.buyId;
    }

    public UUID getSellId() {
        return this.sellId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getBuyPrice() {
        return this.buyPrice;
    }

    public int getSellPrice() {
        return this.sellPrice;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setBuyId(UUID buyId) {
        this.buyId = buyId;
    }

    public void setSellId(UUID sellId) {
        this.sellId = sellId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setBuyPrice(int buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setSellPrice(int sellPrice) {
        this.sellPrice = sellPrice;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flip)) {
            return false;
        }
        Flip other = (Flip)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UUID this$buyId = this.getBuyId();
        UUID other$buyId = other.getBuyId();
        if (this$buyId == null ? other$buyId != null : !((Object)this$buyId).equals(other$buyId)) {
            return false;
        }
        UUID this$sellId = this.getSellId();
        UUID other$sellId = other.getSellId();
        if (this$sellId == null ? other$sellId != null : !((Object)this$sellId).equals(other$sellId)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        if (this.getQuantity() != other.getQuantity()) {
            return false;
        }
        if (this.getBuyPrice() != other.getBuyPrice()) {
            return false;
        }
        if (this.getSellPrice() != other.getSellPrice()) {
            return false;
        }
        Timestamp this$updatedAt = this.getUpdatedAt();
        Timestamp other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Timestamp this$createdAt = this.getCreatedAt();
        Timestamp other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flip;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UUID $buyId = this.getBuyId();
        result = result * 59 + ($buyId == null ? 43 : ((Object)$buyId).hashCode());
        UUID $sellId = this.getSellId();
        result = result * 59 + ($sellId == null ? 43 : ((Object)$sellId).hashCode());
        result = result * 59 + this.getItemId();
        result = result * 59 + this.getQuantity();
        result = result * 59 + this.getBuyPrice();
        result = result * 59 + this.getSellPrice();
        Timestamp $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Timestamp $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Flip(id=" + this.getId() + ", userId=" + this.getUserId() + ", buyId=" + this.getBuyId() + ", sellId=" + this.getSellId() + ", itemId=" + this.getItemId() + ", quantity=" + this.getQuantity() + ", buyPrice=" + this.getBuyPrice() + ", sellPrice=" + this.getSellPrice() + ", updatedAt=" + this.getUpdatedAt() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

