/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.models;

import com.flipper.models.Transaction;
import java.sql.Timestamp;
import java.util.UUID;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

public class Alch {
    public UUID id;
    public UUID userId;
    public UUID buyId;
    public int itemId;
    public int quantity;
    public int buyPrice;
    public int natureRunePrice;
    public int alchPrice;
    private Timestamp updatedAt;
    private Timestamp createdAt;

    public Alch() {
    }

    public Alch(Transaction transaction, ItemManager itemManager) {
        ItemComposition itemComposition = itemManager.getItemComposition(transaction.getItemId());
        this.buyId = transaction.getId();
        this.itemId = transaction.getItemId();
        this.quantity = transaction.getQuantity();
        this.buyPrice = transaction.getPricePer();
        this.natureRunePrice = itemManager.getItemPriceWithSource(561, true);
        this.alchPrice = itemComposition.getHaPrice();
    }

    public String describeAlch(String itemName) {
        return String.valueOf(this.quantity) + " " + itemName + "(s)";
    }

    public int getTotalProfit() {
        return (this.alchPrice - this.buyPrice - this.natureRunePrice) * this.quantity;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public UUID getBuyId() {
        return this.buyId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getBuyPrice() {
        return this.buyPrice;
    }

    public int getNatureRunePrice() {
        return this.natureRunePrice;
    }

    public int getAlchPrice() {
        return this.alchPrice;
    }

    public Timestamp getUpdatedAt() {
        return this.updatedAt;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public void setBuyId(UUID buyId) {
        this.buyId = buyId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setBuyPrice(int buyPrice) {
        this.buyPrice = buyPrice;
    }

    public void setNatureRunePrice(int natureRunePrice) {
        this.natureRunePrice = natureRunePrice;
    }

    public void setAlchPrice(int alchPrice) {
        this.alchPrice = alchPrice;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alch)) {
            return false;
        }
        Alch other = (Alch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UUID this$buyId = this.getBuyId();
        UUID other$buyId = other.getBuyId();
        if (this$buyId == null ? other$buyId != null : !((Object)this$buyId).equals(other$buyId)) {
            return false;
        }
        if (this.getItemId() != other.getItemId()) {
            return false;
        }
        if (this.getQuantity() != other.getQuantity()) {
            return false;
        }
        if (this.getBuyPrice() != other.getBuyPrice()) {
            return false;
        }
        if (this.getNatureRunePrice() != other.getNatureRunePrice()) {
            return false;
        }
        if (this.getAlchPrice() != other.getAlchPrice()) {
            return false;
        }
        Timestamp this$updatedAt = this.getUpdatedAt();
        Timestamp other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Timestamp this$createdAt = this.getCreatedAt();
        Timestamp other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Alch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UUID $buyId = this.getBuyId();
        result = result * 59 + ($buyId == null ? 43 : ((Object)$buyId).hashCode());
        result = result * 59 + this.getItemId();
        result = result * 59 + this.getQuantity();
        result = result * 59 + this.getBuyPrice();
        result = result * 59 + this.getNatureRunePrice();
        result = result * 59 + this.getAlchPrice();
        Timestamp $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Timestamp $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Alch(id=" + this.getId() + ", userId=" + this.getUserId() + ", buyId=" + this.getBuyId() + ", itemId=" + this.getItemId() + ", quantity=" + this.getQuantity() + ", buyPrice=" + this.getBuyPrice() + ", natureRunePrice=" + this.getNatureRunePrice() + ", alchPrice=" + this.getAlchPrice() + ", updatedAt=" + this.getUpdatedAt() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

