/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.helpers;

import com.flipper.api.Api;
import com.flipper.helpers.Log;
import com.flipper.models.Flip;
import com.flipper.models.Transaction;
import com.flipper.responses.LoginResponse;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.RuneLite;

public class Persistor {
    public static Gson gson = new Gson();
    public static final File PARENT_DIRECTORY = new File(RuneLite.RUNELITE_DIR, "flipper");
    public static File directory;
    public static final String SELLS_JSON_FILE = "flipper-sells.json";
    public static final String BUYS_JSON_FILE = "flipper-buys.json";
    public static final String MARGINS_JSON_FILE = "flipper-margins-2.json";
    public static final String FLIPS_JSON_FILE = "flipper-flips.json";
    public static final String LOGIN_RESPONSE_JSON_FILE = "flipper-login-response.json";

    public static void setUp(String directoryPath) throws IOException {
        directory = new File(directoryPath);
        Persistor.createDirectory(directory);
        Persistor.createRequiredFiles();
    }

    public static void setUp() throws IOException {
        directory = PARENT_DIRECTORY;
        Persistor.createDirectory(PARENT_DIRECTORY);
        Persistor.createRequiredFiles();
    }

    private static void createRequiredFiles() throws IOException {
        Persistor.generateFileIfDoesNotExist(SELLS_JSON_FILE);
        Persistor.generateFileIfDoesNotExist(BUYS_JSON_FILE);
        Persistor.generateFileIfDoesNotExist(MARGINS_JSON_FILE);
        Persistor.generateFileIfDoesNotExist(LOGIN_RESPONSE_JSON_FILE);
    }

    private static void generateFileIfDoesNotExist(String filename) throws IOException {
        File file = new File(directory, filename);
        if (!file.exists() && !file.createNewFile()) {
            Log.info("Failed to generate file " + file.getPath());
        }
    }

    private static void createDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            Log.info("Creating flipper directory");
            if (!directory.mkdir()) {
                throw new IOException("unable to create parent directory!");
            }
        }
    }

    public static LoginResponse loadLoginResponse() throws IOException {
        String jsonString = Persistor.getFileContent(LOGIN_RESPONSE_JSON_FILE);
        LoginResponse loadedLoginResponse = (LoginResponse)gson.fromJson(jsonString, LoginResponse.class);
        if (loadedLoginResponse != null && !loadedLoginResponse.error) {
            Api.setLoginResponse(loadedLoginResponse);
        }
        return loadedLoginResponse;
    }

    public static void saveLoginResponse(LoginResponse loginResponse) throws IOException {
        if (loginResponse == null) {
            return;
        }
        File file = new File(directory, LOGIN_RESPONSE_JSON_FILE);
        String json = gson.toJson((Object)loginResponse);
        Files.write(file.toPath(), json.getBytes(), new OpenOption[0]);
    }

    public static void deleteLoginResponse() throws IOException {
        Path loginResponsePath = Paths.get(directory.getAbsolutePath(), LOGIN_RESPONSE_JSON_FILE);
        if (Files.exists(loginResponsePath, new LinkOption[0])) {
            Files.delete(loginResponsePath);
        }
        Api.loginResponse = null;
        Api.jwt = null;
    }

    public static void deleteFlipsJsonFile() throws IOException {
        Path flipsJsonPath = Persistor.getFlipsJsonPath();
        if (Files.exists(flipsJsonPath, new LinkOption[0])) {
            Files.delete(flipsJsonPath);
        }
    }

    public static boolean checkDoesFlipsFileExist() throws IOException {
        Path flipsJsonPath = Persistor.getFlipsJsonPath();
        return Files.exists(flipsJsonPath, new LinkOption[0]);
    }

    public static Path getFlipsJsonPath() {
        return Paths.get(directory.getAbsolutePath(), FLIPS_JSON_FILE);
    }

    public static void saveJson(List<?> list, String filename) throws IOException {
        File file = new File(directory, filename);
        String json = gson.toJson(list);
        Files.write(file.toPath(), json.getBytes(), new OpenOption[0]);
    }

    private static String getFileContent(String filename) throws IOException {
        Path filePath = Paths.get(directory.getAbsolutePath(), filename);
        byte[] fileBytes = Files.readAllBytes(filePath);
        return new String(fileBytes);
    }

    public static boolean saveBuys(List<Transaction> buys) {
        try {
            Persistor.saveJson(buys, BUYS_JSON_FILE);
            return true;
        }
        catch (Exception error) {
            Log.info("Failed to save buys " + error.toString());
            return false;
        }
    }

    public static boolean saveSells(List<Transaction> sells) {
        try {
            Persistor.saveJson(sells, SELLS_JSON_FILE);
            return true;
        }
        catch (Exception error) {
            Log.info("Failed to save sells " + error.toString());
            return false;
        }
    }

    public static boolean saveMargins(List<Flip> margins) {
        try {
            Persistor.saveJson(margins, MARGINS_JSON_FILE);
            return true;
        }
        catch (Exception error) {
            Log.info("Failed to save flips " + error.toString());
            return false;
        }
    }

    public static List<Flip> loadMargins() throws IOException {
        Type type;
        String jsonString = Persistor.getFileContent(MARGINS_JSON_FILE);
        List margins = (List)gson.fromJson(jsonString, type = new TypeToken<List<Flip>>(){}.getType());
        if (margins == null) {
            return new ArrayList<Flip>();
        }
        return margins;
    }

    public static List<Transaction> loadBuys() throws IOException {
        Type type;
        String jsonString = Persistor.getFileContent(BUYS_JSON_FILE);
        List buys = (List)gson.fromJson(jsonString, type = new TypeToken<List<Transaction>>(){}.getType());
        if (buys == null) {
            return new ArrayList<Transaction>();
        }
        return buys;
    }

    public static List<Transaction> loadSells() throws IOException {
        Type type;
        String jsonString = Persistor.getFileContent(SELLS_JSON_FILE);
        List sells = (List)gson.fromJson(jsonString, type = new TypeToken<List<Transaction>>(){}.getType());
        if (sells == null) {
            return new ArrayList<Transaction>();
        }
        return sells;
    }
}

