/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.controllers;

import com.flipper.api.Api;
import com.flipper.api.UserApi;
import com.flipper.responses.LoginResponse;
import com.flipper.views.login.LoginPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import javax.swing.JOptionPane;

public class LoginController {
    LoginPage loginPage;
    private String email;
    private String password;
    Runnable changeToLoggedInViewRunnable;

    public LoginController(Runnable changeToLoggedInViewRunnable) {
        this.changeToLoggedInViewRunnable = changeToLoggedInViewRunnable;
        Consumer<String> onEmailTextChangedListener = text -> this.onEmailTextChanged((String)text);
        Consumer<String> onPasswordTextChangedListener = text -> this.onPasswordTextChanged((String)text);
        ActionListener onLoginPressedListener = event -> this.onLoginPressed(event);
        this.loginPage = new LoginPage(onEmailTextChangedListener, onPasswordTextChangedListener, onLoginPressedListener);
    }

    public void onLoginPressed(ActionEvent event) {
        Consumer<LoginResponse> loginCallback = loginResponse -> {
            if (loginResponse != null && !loginResponse.error) {
                Api.setLoginResponse(loginResponse);
                this.changeToLoggedInViewRunnable.run();
            } else {
                JOptionPane.showMessageDialog(null, loginResponse.message);
            }
        };
        if (this.email == null || this.password == null) {
            return;
        }
        UserApi.login(this.email, this.password, loginCallback);
    }

    public void onEmailTextChanged(String newEmail) {
        this.email = newEmail;
    }

    public void onPasswordTextChanged(String newPassword) {
        this.password = newPassword;
    }

    public LoginPage getPanel() {
        return this.loginPage;
    }
}

