/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.controllers;

import com.flipper.FlipperConfig;
import com.flipper.api.FlipApi;
import com.flipper.api.UploadApi;
import com.flipper.helpers.GrandExchange;
import com.flipper.helpers.Log;
import com.flipper.helpers.Persistor;
import com.flipper.models.Flip;
import com.flipper.models.Transaction;
import com.flipper.responses.FlipResponse;
import com.flipper.views.components.Pagination;
import com.flipper.views.flips.FlipPage;
import com.flipper.views.flips.FlipPanel;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

public class FlipsController {
    private List<Flip> flips = new ArrayList<Flip>();
    private List<Flip> filteredFlips = new ArrayList<Flip>();
    private FlipPage flipPage;
    private Consumer<UUID> removeFlipConsumer;
    private Runnable refreshFlipsRunnable;
    private String totalProfit = "0";
    private Pagination pagination;
    private String searchText;
    private ItemManager itemManager;
    private Consumer<String> onSearchTextChangedCallback;
    private boolean isTrackingFlips = true;

    public FlipsController(ItemManager itemManager, FlipperConfig config) throws IOException {
        this.flips = new ArrayList<Flip>();
        this.removeFlipConsumer = id -> this.removeFlip((UUID)id);
        this.refreshFlipsRunnable = () -> this.loadFlips();
        this.itemManager = itemManager;
        this.onSearchTextChangedCallback = searchText -> this.onSearchTextChanged((String)searchText);
        Runnable toggleIsTrackingFlipsRunnable = () -> {
            this.isTrackingFlips = !this.isTrackingFlips;
        };
        this.flipPage = new FlipPage(this.refreshFlipsRunnable, this.onSearchTextChangedCallback, toggleIsTrackingFlipsRunnable, this.isTrackingFlips);
        Consumer<Object> renderItemCallback = flip -> {
            FlipPanel flipPanel = new FlipPanel((Flip)flip, itemManager, this.removeFlipConsumer, config.isPromptDeleteBuy());
            this.flipPage.addFlipPanel(flipPanel);
        };
        Runnable buildViewCallback = () -> this.buildView();
        try {
            if (Persistor.checkDoesFlipsFileExist()) {
                Consumer<FlipResponse> flipUploadCallback = flipResponse -> {
                    if (flipResponse != null) {
                        this.totalProfit = flipResponse.totalProfit;
                        this.flips = flipResponse.flips;
                        try {
                            Persistor.deleteFlipsJsonFile();
                        }
                        catch (IOException error) {
                            Log.info("Failed to delete flips json file");
                        }
                    }
                    this.buildView();
                };
                UploadApi.uploadFlips(flipUploadCallback);
            }
        }
        catch (Exception error) {
            Log.info("Failed to upload flips");
        }
        this.pagination = new Pagination(renderItemCallback, 15, buildViewCallback);
        this.loadFlips();
    }

    public void onSearchTextChanged(String searchText) {
        this.searchText = searchText;
        this.pagination.resetPage();
        this.buildView();
    }

    public void addFlip(Flip flip) {
        if (this.isTrackingFlips) {
            Consumer<FlipResponse> createFlipCallback = flipResponse -> {
                this.totalProfit = flipResponse.totalProfit;
                this.flips.add(0, flipResponse.flip);
                this.buildView();
            };
            FlipApi.createFlip(flip, createFlipCallback);
        }
    }

    public void removeFlip(UUID flipId) {
        Consumer<FlipResponse> deleteFlipCallback = flipResponse -> {
            if (flipResponse != null) {
                this.totalProfit = flipResponse.totalProfit;
                Iterator<Flip> flipsIter = this.flips.iterator();
                while (flipsIter.hasNext()) {
                    Flip flip = flipsIter.next();
                    if (!flip.getId().equals(flipId)) continue;
                    flipsIter.remove();
                    this.buildView();
                }
            }
        };
        FlipApi.deleteFlip(flipId, deleteFlipCallback);
    }

    public FlipPage getPage() {
        return this.flipPage;
    }

    public void loadFlips() {
        Consumer<FlipResponse> getFlipsCallback = flipResponse -> {
            if (flipResponse != null) {
                this.totalProfit = flipResponse.totalProfit;
                this.flips = flipResponse.flips;
                this.filteredFlips = this.flips;
            }
            this.buildView();
        };
        FlipApi.getFlips(getFlipsCallback);
    }

    private void updateFlip(Transaction sell, Transaction buy, Flip flip) {
        Consumer<FlipResponse> updateFlipCallback = flipResponse -> {
            if (flipResponse != null) {
                this.totalProfit = flipResponse.totalProfit;
                this.buildView();
            }
        };
        flip.sellPrice = sell.getPricePer();
        flip.buyPrice = buy.getPricePer();
        flip.quantity = sell.getQuantity();
        flip.itemId = sell.getItemId();
        FlipApi.updateFlip(flip, updateFlipCallback);
    }

    private boolean isRender(Flip flip) {
        ItemComposition itemComp = this.itemManager.getItemComposition(flip.getItemId());
        String itemName = itemComp.getName();
        if (this.searchText != null && itemName.toLowerCase().contains(this.searchText.toLowerCase())) {
            return true;
        }
        return this.searchText == null || this.searchText == "";
    }

    public Flip upsertFlip(Transaction sell, List<Transaction> buys) {
        block5: {
            ListIterator<Transaction> buysIterator;
            block4: {
                buysIterator = buys.listIterator(buys.size());
                if (!sell.isFlipped()) break block4;
                ListIterator<Flip> flipsIterator = this.flips.listIterator();
                while (flipsIterator.hasNext()) {
                    Flip flip = flipsIterator.next();
                    if (!flip.getSellId().equals(sell.id)) continue;
                    while (buysIterator.hasPrevious()) {
                        Transaction buy = buysIterator.previous();
                        if (!buy.id.equals(flip.getBuyId())) continue;
                        this.updateFlip(sell, buy, flip);
                        flipsIterator.set(flip);
                        return flip;
                    }
                }
                break block5;
            }
            if (!this.isTrackingFlips) break block5;
            while (buysIterator.hasPrevious()) {
                Transaction buy = buysIterator.previous();
                if (!GrandExchange.checkIsSellAFlipOfBuy(sell, buy)) continue;
                Flip flip = new Flip(buy, sell);
                if (!flip.isMarginCheck()) {
                    this.addFlip(flip);
                    buy.setIsFlipped(true);
                    sell.setIsFlipped(true);
                }
                return flip;
            }
        }
        return null;
    }

    public void filterList() {
        if (this.searchText == "" || this.searchText == null) {
            this.filteredFlips = this.flips;
        } else {
            Iterator<Flip> flipsIter = this.flips.iterator();
            this.filteredFlips = new ArrayList<Flip>();
            while (flipsIter.hasNext()) {
                Flip currentFlip = flipsIter.next();
                if (!this.isRender(currentFlip)) continue;
                this.filteredFlips.add(currentFlip);
            }
        }
    }

    public void buildView() {
        SwingUtilities.invokeLater(() -> {
            this.filterList();
            this.flipPage.resetContainer(this.isTrackingFlips);
            this.flipPage.add((Component)this.pagination.getComponent(this.filteredFlips), "South");
            this.pagination.renderFromBeginning(this.filteredFlips);
            this.flipPage.setTotalProfit(this.totalProfit);
            this.flipPage.revalidate();
        });
    }

    public List<Flip> getFlips() {
        return this.flips;
    }

    public void setFlips(List<Flip> flips) {
        this.flips = flips;
    }
}

