/*
 * Decompiled with CFR 0.152.
 */
package com.flipper.api;

import com.flipper.helpers.Log;
import com.flipper.responses.LoginResponse;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Api {
    public static String baseUrl = "https://api.osrs-flipper.com";
    public static OkHttpClient client = new OkHttpClient();
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static String jwt = "";
    public static LoginResponse loginResponse;
    public static Gson gson;
    public static final String POST = "post";
    public static final String PUT = "put";
    public static final String DELETE = "delete";
    public static final String GET = "get";

    public static void setJwt(String jwt) {
        Api.jwt = jwt;
    }

    public static void setLoginResponse(LoginResponse loginResponse) {
        Api.loginResponse = loginResponse;
        jwt = loginResponse.jwt;
    }

    public static String createUrl(String route) {
        return baseUrl + route;
    }

    public static <T> void request(String method, String route, final Consumer<T> callback, final Class<T> jsonClass, Object params) {
        Request request;
        String url = Api.createUrl(route);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (jwt != null) {
            requestBuilder.header("Authorization", jwt);
        }
        String paramsJson = params == null ? "" : gson.toJson(params);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)paramsJson);
        switch (method) {
            case "post": {
                request = requestBuilder.post(body).build();
                break;
            }
            case "delete": {
                request = requestBuilder.delete(body).build();
                break;
            }
            case "put": {
                request = requestBuilder.put(body).build();
                break;
            }
            default: {
                request = requestBuilder.build();
            }
        }
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                callback.accept(gson.fromJson(response.body().string(), jsonClass));
            }

            public void onFailure(Call call, IOException error) {
                Log.info("Flipper Server Error");
            }
        });
    }

    public static <T> void get(String route, Consumer<T> callback, Class<T> jsonClass, Object params) {
        Api.request(GET, route, callback, jsonClass, params);
    }

    public static <T> void post(String route, Consumer<T> callback, Class<T> jsonClass, Object params) {
        Api.request(POST, route, callback, jsonClass, params);
    }

    public static <T> void put(String route, Consumer<T> callback, Class<T> jsonClass, Object params) {
        Api.request(PUT, route, callback, jsonClass, params);
    }

    public static <T> void delete(String route, Consumer<T> callback, Class<T> jsonClass, Object params) {
        Api.request(DELETE, route, callback, jsonClass, params);
    }

    static {
        gson = new Gson();
    }
}

