/*
 * Decompiled with CFR 0.152.
 */
package com.flipper;

import com.flipper.FlipperConfig;
import com.flipper.api.Api;
import com.flipper.controllers.AlchsController;
import com.flipper.controllers.BuysController;
import com.flipper.controllers.FlipsController;
import com.flipper.controllers.LoginController;
import com.flipper.controllers.MarginsController;
import com.flipper.controllers.SellsController;
import com.flipper.helpers.GrandExchange;
import com.flipper.helpers.Log;
import com.flipper.helpers.Persistor;
import com.flipper.models.Alch;
import com.flipper.models.Flip;
import com.flipper.models.Transaction;
import com.flipper.responses.LoginResponse;
import com.flipper.views.TabManager;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.events.GrandExchangeOfferChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Flipper")
public class FlipperPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private FlipperConfig config;
    private BuysController buysController;
    private SellsController sellsController;
    private FlipsController flipsController;
    private MarginsController marginsController;
    private LoginController loginController;
    private AlchsController alchsController;
    private NavigationButton navButton;
    private TabManager tabManager;

    protected void startUp() throws Exception {
        try {
            Persistor.setUp();
            LoginResponse loginResponse = Persistor.loadLoginResponse();
            Boolean isLoggedIn = loginResponse != null;
            this.tabManager = new TabManager();
            this.setUpNavigationButton();
            if (isLoggedIn.booleanValue()) {
                this.changeToLoggedInView();
            } else {
                this.changeToLoggedOutView();
            }
        }
        catch (Exception e) {
            Log.info("Flipper failed to start");
        }
    }

    private void setUpNavigationButton() {
        this.navButton = NavigationButton.builder().tooltip("Flipper").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/flipper_nav_button.png")).priority(4).panel((PluginPanel)this.tabManager).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    private void alchFromBuy(Transaction buy) {
        Alch alch = new Alch(buy, this.itemManager);
        this.alchsController.addAlch(alch);
    }

    private void flipFromMargin(Flip margin) {
        this.flipsController.addFlip(margin);
        this.marginsController.removeMargin(margin.getId());
    }

    private void changeToLoggedInView() {
        SwingUtilities.invokeLater(() -> {
            try {
                Runnable changeToLoggedOutViewRunnable = () -> this.changeToLoggedOutView();
                this.alchsController = new AlchsController(this.itemManager, this.config);
                Consumer<Transaction> highAlchCallback = buy -> this.alchFromBuy((Transaction)buy);
                Consumer<Flip> convertToFlipConsumer = margin -> this.flipFromMargin((Flip)margin);
                this.flipsController = new FlipsController(this.itemManager, this.config);
                this.buysController = new BuysController(this.itemManager, highAlchCallback, this.config);
                this.sellsController = new SellsController(this.itemManager, this.config);
                this.marginsController = new MarginsController(this.itemManager, this.config, convertToFlipConsumer);
                this.tabManager.renderLoggedInView(this.buysController.getPage(), this.sellsController.getPage(), this.flipsController.getPage(), this.alchsController.getPage(), this.marginsController.getPage(), changeToLoggedOutViewRunnable);
            }
            catch (IOException e) {
                Log.info("Flipper: Failed to load required files");
            }
        });
    }

    private void changeToLoggedOutView() {
        try {
            Runnable changeToLoggedInViewRunnable = () -> this.changeToLoggedInView();
            Persistor.deleteLoginResponse();
            SwingUtilities.invokeLater(() -> {
                this.loginController = new LoginController(changeToLoggedInViewRunnable);
                this.tabManager.renderLoggedOutView(this.loginController.getPanel());
            });
        }
        catch (IOException e) {
            Log.info("Flipper: Failed to load required files");
        }
    }

    private void saveAll() {
        try {
            this.buysController.saveTransactions();
            this.sellsController.saveTransactions();
            this.marginsController.saveMargins();
            Persistor.saveLoginResponse(Api.loginResponse);
        }
        catch (Exception error) {
            Log.info("Failed to save Flipper files");
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.saveAll();
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown clientShutdownEvent) throws IOException {
        this.saveAll();
    }

    @Subscribe
    public void onGrandExchangeOfferChanged(GrandExchangeOfferChanged newOfferEvent) {
        int slot = newOfferEvent.getSlot();
        GrandExchangeOffer offer = newOfferEvent.getOffer();
        GrandExchangeOfferState offerState = offer.getState();
        int quantitySold = offer.getQuantitySold();
        if (offerState != GrandExchangeOfferState.EMPTY && quantitySold != 0) {
            boolean isBuy = GrandExchange.checkIsBuy(offerState);
            if (isBuy) {
                this.buysController.upsertTransaction(offer, slot);
            } else {
                Transaction sell = this.sellsController.upsertTransaction(offer, slot);
                Flip flip = this.flipsController.upsertFlip(sell, this.buysController.getTransactions());
                boolean isOfferComplete = GrandExchange.checkIsComplete(offerState);
                if (flip != null && flip.isMarginCheck() && isOfferComplete) {
                    this.buysController.removeTransaction(flip.getBuyId());
                    this.sellsController.removeTransaction(sell.id);
                    flip.id = UUID.randomUUID();
                    flip.sellPrice = sell.getPricePer();
                    this.marginsController.addMargin(flip);
                }
            }
        }
    }

    @Provides
    FlipperConfig provideConfig(ConfigManager configManager) {
        return (FlipperConfig)configManager.getConfig(FlipperConfig.class);
    }
}

