/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.ui;

import com.raidsdrymeter.data.UniqueItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;

public class UniquePanel
extends JPanel {
    private final float alphaHas = 1.0f;
    private static final Dimension panelSize = new Dimension(215, 50);
    private static final Border panelBorder = new EmptyBorder(3, 0, 3, 0);
    private static final Color panelBackgroundColor = ColorScheme.DARKER_GRAY_COLOR;

    UniquePanel(Collection<UniqueItem> items, ItemManager itemManager, int itemMissingAlpha) {
        float alphaMissing = (float)itemMissingAlpha / 100.0f;
        JPanel panel = new JPanel();
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        panel.setBorder(new EmptyBorder(3, 6, 0, 3));
        this.setLayout(new BorderLayout());
        this.setBorder(panelBorder);
        this.setBackground(panelBackgroundColor);
        this.setPreferredSize(panelSize);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 5;
        for (UniqueItem l : items) {
            int quantity = l.getQty();
            float alpha = quantity > 0 ? 1.0f : alphaMissing;
            AsyncBufferedImage image = itemManager.getImage(l.getItemID(), quantity, quantity > 1);
            BufferedImage opaque = ImageUtil.alphaOffset((Image)image, (float)alpha);
            JLabel icon = new JLabel();
            icon.setToolTipText(UniquePanel.buildToolTip(l, quantity));
            icon.setIcon(new ImageIcon(opaque));
            icon.setVerticalAlignment(0);
            icon.setHorizontalAlignment(0);
            panel.add((Component)icon, c);
            ++c.gridx;
            image.onLoaded(() -> {
                icon.setIcon(new ImageIcon(ImageUtil.alphaOffset((Image)image, (float)alpha)));
                icon.revalidate();
                icon.repaint();
            });
        }
        this.add((Component)panel, "North");
    }

    private static String buildToolTip(UniqueItem item, int qty) {
        String s = "<html>" + item.getName();
        if (item.getPrice() > 0) {
            s = s + "<br/>(x" + QuantityFormatter.quantityToStackSize((long)item.getPrice()) + ")";
        }
        if (qty > 0) {
            s = s + "<br/>x " + QuantityFormatter.formatNumber((long)qty);
        }
        if (item.getPrice() > 0 && qty > 0) {
            s = s + "<br/>(" + QuantityFormatter.quantityToStackSize((long)(qty * item.getPrice())) + ")</html;";
        }
        s = s + "</html>";
        return s;
    }
}

