/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.ui;

import com.raidsdrymeter.data.RaidTab;
import com.raidsdrymeter.ui.RaidsDryMeterPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;

public class SelectionPanel
extends JPanel {
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BUTTON_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final Color BUTTON_HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    private final RaidsDryMeterPanel parent;
    private final ItemManager itemManager;

    SelectionPanel(RaidsDryMeterPanel parent, ItemManager itemManager) {
        this.parent = parent;
        this.itemManager = itemManager;
        this.setLayout(new GridBagLayout());
        this.setBackground(BACKGROUND_COLOR);
        this.createPanel();
    }

    private void createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.createRaidTabPanel(), c);
        ++c.gridy;
    }

    private JPanel createRaidTabPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 0, 0, 0);
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(new EmptyBorder(0, 0, 0, 0));
        container.add((Component)this.createRaidTabs(), c);
        return container;
    }

    private JPanel createRaidTabs() {
        JPanel container = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        MaterialTabGroup thisTabGroup = new MaterialTabGroup();
        thisTabGroup.setLayout((LayoutManager)new GridLayout(0, 2, 7, 0));
        thisTabGroup.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        Collection<RaidTab> categoryTabs = RaidTab.getByCategoryName("Raids");
        for (RaidTab tab : categoryTabs) {
            MaterialTab materialTab = new MaterialTab("", thisTabGroup, null);
            materialTab.setName(tab.getName());
            materialTab.setToolTipText(tab.getName());
            materialTab.setOnSelectEvent(() -> {
                this.parent.setUniqueLogToNull();
                this.parent.requestUniqueLog(tab.getType(), tab.getName());
                return true;
            });
            AsyncBufferedImage image = this.itemManager.getImage(tab.getItemID());
            Runnable resize = () -> {
                materialTab.setIcon((Icon)new ImageIcon(image.getScaledInstance(35, 35, 4)));
                materialTab.setOpaque(true);
                materialTab.setBackground(Color.DARK_GRAY);
                materialTab.setHorizontalAlignment(0);
                materialTab.setVerticalAlignment(0);
                materialTab.setPreferredSize(new Dimension(55, 35));
            };
            image.onLoaded(resize);
            resize.run();
            thisTabGroup.addTab(materialTab);
        }
        container.add((Component)thisTabGroup, c);
        return container;
    }
}

