/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.ui;

import com.google.common.collect.ArrayListMultimap;
import com.raidsdrymeter.data.UniqueItem;
import com.raidsdrymeter.data.UniqueLog;
import com.raidsdrymeter.storage.RaidRecord;
import com.raidsdrymeter.storage.UniqueEntry;
import com.raidsdrymeter.ui.DataPanel;
import com.raidsdrymeter.ui.UniquePanel;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.QuantityFormatter;

public class RaidsPanel
extends PluginPanel {
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private final ItemManager itemManager;
    private final UniqueLog uniqueLog;
    private int totalUniques = 0;
    private double totalGPFromUniques = 0.0;

    RaidsPanel(UniqueLog log, ItemManager itemManager) {
        this.uniqueLog = log;
        this.itemManager = itemManager;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(3, 5, 0, 5));
        this.setBackground(BACKGROUND_COLOR);
        this.createPanel(log);
    }

    private void createPanel(UniqueLog uniqueLog) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        ArrayListMultimap positionMap = ArrayListMultimap.create();
        HashSet<Integer> uniqueIds = new HashSet<Integer>();
        for (UniqueItem item : uniqueLog.getUniques()) {
            int linkedId;
            int id = item.getItemID();
            if (id != -1) {
                uniqueIds.add(id);
            }
            if ((linkedId = item.getLinkedID()) != -1) {
                uniqueIds.add(linkedId);
            }
            UniqueEntry entry = uniqueLog.getConsolidated().get(id);
            UniqueEntry notedEntry = uniqueLog.getConsolidated().get(linkedId);
            int qty = entry == null ? 0 : entry.getQuantity() + (notedEntry == null ? 0 : notedEntry.getQuantity());
            item.setQty(qty);
            positionMap.put((Object)item.getPosition(), (Object)item);
            this.totalUniques += qty;
            this.totalGPFromUniques += (double)(item.getPrice() * qty);
        }
        Iterator<UniqueItem> iterator = positionMap.keySet().iterator();
        while (iterator.hasNext()) {
            int position = (Integer)((Object)iterator.next());
            Collection uniques = positionMap.get((Object)position);
            UniquePanel p = new UniquePanel(uniques, this.itemManager, 35);
            this.add(p, c);
            ++c.gridy;
        }
        if (uniqueLog.getRecords().size() > 0) {
            int amount = uniqueLog.getRecords().size();
            RaidRecord record = uniqueLog.getRecords().get(amount - 1);
            int personalRaidsDry = record.getPersonalRaidsDry();
            int personalPointsDry = 0;
            double personalRaidsOdds = 0.0;
            int totalPoints = 0;
            int personalStreak = 0;
            if (personalRaidsDry != 0) {
                for (int x = uniqueLog.getRecords().size() - personalRaidsDry; x < uniqueLog.getRecords().size(); ++x) {
                    if ((totalPoints += uniqueLog.getRecords().get(x).getPersonalPoints()) < 867600) {
                        personalPointsDry += uniqueLog.getRecords().get(x).getPersonalPoints();
                    }
                    if (totalPoints <= 867600) continue;
                    totalPoints -= 867600;
                    ++personalStreak;
                    personalPointsDry += uniqueLog.getRecords().get(x).getPersonalPoints();
                }
                personalRaidsOdds = 867600.0 / (double)(personalPointsDry / personalRaidsDry);
            }
            if (record.getKillCount() != -1) {
                DataPanel p = new DataPanel("KillCount: ", record.getKillCount());
                this.add(p, c);
                ++c.gridy;
                System.out.println(uniqueLog.getName() + uniqueLog.getRecords().size());
                DataPanel p2 = new DataPanel("Logged KC: ", uniqueLog.getRecords().size());
                this.add(p2, c);
                ++c.gridy;
                DataPanel p3 = new DataPanel("Total Uniques: ", this.totalUniques);
                this.add(p3, c);
                ++c.gridy;
                String holder = String.format("%,.0f", personalPointsDry);
                DataPanel p4 = new DataPanel("Personal Points Dry: ", holder);
                this.add(p4, c);
                ++c.gridy;
                DataPanel p6 = new DataPanel("Personal Raids Dry: ", personalRaidsDry);
                this.add(p6, c);
                ++c.gridy;
                holder = String.format("%,.2f", personalRaidsOdds);
                DataPanel p8 = new DataPanel("Personal Raids Odds: ", holder);
                this.add(p8, c);
                ++c.gridy;
                DataPanel p9 = new DataPanel("Personal Raids Dry Streak: ", personalStreak);
                this.add(p9, c);
                ++c.gridy;
                DataPanel p12 = new DataPanel("Gp From Personal Uniques: ", QuantityFormatter.quantityToStackSize((long)((long)this.totalGPFromUniques)));
                this.add(p12, c);
                ++c.gridy;
                holder = String.format("%,.2f", this.getEstimateGpPerPoint());
                DataPanel p13 = new DataPanel("Est. Gp per Point: ", holder);
                this.add(p13, c);
                ++c.gridy;
                holder = String.format("%,.2f", this.getActualGpPerPoints());
                DataPanel p14 = new DataPanel("Actual. Gp Per Personal Point: ", holder);
                this.add(p14, c);
                ++c.gridy;
            }
        } else if (uniqueLog.getName().equals("Theater of Blood")) {
            DataPanel holder = new DataPanel("Coming soon!");
            this.add(holder, c);
            ++c.gridy;
        }
    }

    void addedRecord(RaidRecord record) {
        this.uniqueLog.addRecord(record);
        this.removeAll();
        this.createPanel(this.uniqueLog);
        this.revalidate();
        this.repaint();
    }

    double getEstimateGpPerPoint() {
        double gpPerPoint = 0.0;
        ArrayList<UniqueItem> uniqueItems = new ArrayList<UniqueItem>(UniqueItem.getUniquesForBoss("Chambers of Xeric"));
        for (UniqueItem uniqueItem : uniqueItems) {
            double dropRate = uniqueItem.getDropRate();
            gpPerPoint += (double)uniqueItem.getPrice() / (712500.0 / dropRate);
        }
        return gpPerPoint;
    }

    double getActualGpPerPoints() {
        double gp = 0.0;
        ArrayList<RaidRecord> records = new ArrayList<RaidRecord>(this.uniqueLog.getRecords());
        ArrayList<UniqueItem> uniqueItems = new ArrayList<UniqueItem>(UniqueItem.getUniquesForBoss("Chambers of Xeric"));
        double totalPoints = 0.0;
        for (RaidRecord record : records) {
            ArrayList<UniqueEntry> uniqueDrops = new ArrayList<UniqueEntry>(record.getUniques());
            totalPoints += (double)record.getPersonalPoints();
            for (UniqueEntry uniqueDrop : uniqueDrops) {
                for (UniqueItem uniqueItem : uniqueItems) {
                    if (uniqueDrop.getId() != uniqueItem.getItemID()) continue;
                    gp += (double)uniqueItem.getPrice();
                }
            }
        }
        return gp / totalPoints;
    }
}

