/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.ui;

import com.raidsdrymeter.RaidsDryMeterPlugin;
import com.raidsdrymeter.data.UniqueLog;
import com.raidsdrymeter.storage.RaidRecord;
import com.raidsdrymeter.ui.EmptyPanel;
import com.raidsdrymeter.ui.RaidsPanel;
import com.raidsdrymeter.ui.SelectionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.loottracker.LootRecordType;

public class RaidsDryMeterPanel
extends PluginPanel {
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private static final Color BUTTON_HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    private final RaidsDryMeterPlugin plugin;
    private UniqueLog uniqueLog;
    private final ItemManager itemManager;
    RaidsPanel raidsPanel;
    SelectionPanel selectionPanel;
    EmptyPanel emptyPanel;
    private final JPanel namePanel = new JPanel();

    public RaidsDryMeterPanel(RaidsDryMeterPlugin raidsDryMeterPlugin, ItemManager itemManager) {
        this.itemManager = itemManager;
        this.plugin = raidsDryMeterPlugin;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        GridBagConstraints c = this.createGridBag();
        this.showSelectionView();
        ++c.gridy;
    }

    public void addLog(RaidRecord r) {
        if (this.uniqueLog == null) {
            this.requestUniqueLog(r.getType(), r.getName());
        } else if (this.uniqueLog.getName().equalsIgnoreCase(r.getName())) {
            this.raidsPanel.addedRecord(r);
        }
    }

    public void useLog(UniqueLog log) {
        this.uniqueLog = log;
        this.showRaidView();
    }

    public void requestUniqueLog(LootRecordType type, String name) {
        this.plugin.requestUniqueLog(type, name);
    }

    public void refreshUI() {
        if (this.raidsPanel != null) {
            this.remove((Component)((Object)this.raidsPanel));
            this.raidsPanel = null;
        }
        this.showSelectionView();
    }

    public void showSelectionView() {
        if (this.selectionPanel != null) {
            this.remove(this.selectionPanel);
            this.selectionPanel = null;
        }
        this.selectionPanel = new SelectionPanel(this, this.itemManager);
        GridBagConstraints c = this.createGridBag();
        this.add(this.selectionPanel, c);
        ++c.gridy;
        this.revalidate();
        this.repaint();
    }

    public void addEmptyPanel(GridBagConstraints c) {
        this.emptyPanel = new EmptyPanel("test");
        this.add(this.emptyPanel);
        this.revalidate();
        this.repaint();
    }

    public void showRaidView() {
        if (this.emptyPanel != null) {
            this.remove(this.emptyPanel);
            this.emptyPanel = null;
        }
        if (this.raidsPanel != null) {
            this.remove((Component)((Object)this.raidsPanel));
        }
        GridBagConstraints c = this.createGridBag();
        this.raidsPanel = new RaidsPanel(this.uniqueLog, this.itemManager);
        ++c.gridy;
        this.add((Component)((Object)this.raidsPanel), c);
        this.revalidate();
        this.repaint();
    }

    private JLabel createIconLabel(BufferedImage icon) {
        final JLabel label = new JLabel();
        label.setIcon(new ImageIcon(icon));
        label.setOpaque(true);
        label.setBackground(BACKGROUND_COLOR);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(BUTTON_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(BACKGROUND_COLOR);
            }
        });
        return label;
    }

    public GridBagConstraints createGridBag() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        return c;
    }

    public void setUniqueLogToNull() {
        this.uniqueLog = null;
    }

    public JPanel getNamePanel() {
        return this.namePanel;
    }
}

