/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.QuantityFormatter;

public class DataPanel
extends JPanel {
    private static final Border PANEL_BORDER = BorderFactory.createMatteBorder(3, 0, 3, 0, ColorScheme.DARK_GRAY_COLOR);
    private static final Color PANEL_BACKGROUND_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private static final Border CONTAINER_BORDER = BorderFactory.createMatteBorder(0, 15, 0, 15, PANEL_BACKGROUND_COLOR);
    JLabel total;

    DataPanel(String text, int data) {
        this.setLayout(new GridBagLayout());
        this.setBorder(PANEL_BORDER);
        this.setBackground(PANEL_BACKGROUND_COLOR);
        JLabel textJ = new JLabel(text, 0);
        this.total = new JLabel(QuantityFormatter.quantityToStackSize((long)data), 0);
        JPanel panel = DataPanel.createPanel();
        panel.add(textJ);
        panel.add(this.total);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 15;
        this.add((Component)panel, c);
    }

    DataPanel(String text, String formattedData) {
        this.setLayout(new GridBagLayout());
        this.setBorder(PANEL_BORDER);
        this.setBackground(PANEL_BACKGROUND_COLOR);
        JLabel textJ = new JLabel(text, 0);
        this.total = new JLabel(formattedData, 0);
        JPanel panel = DataPanel.createPanel();
        panel.add(textJ);
        panel.add(this.total);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 15;
        this.add((Component)panel, c);
    }

    DataPanel(String text) {
        this.setLayout(new BorderLayout());
        this.setBorder(PANEL_BORDER);
        this.setBackground(PANEL_BACKGROUND_COLOR);
        JLabel textJ = new JLabel(text, 0);
        textJ.setHorizontalAlignment(0);
        JPanel panel = DataPanel.createPanel();
        panel.add(textJ);
        this.add((Component)panel, "Center");
    }

    private static JPanel createPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1, 1, 1));
        panel.setBorder(CONTAINER_BORDER);
        panel.setBackground(PANEL_BACKGROUND_COLOR);
        return panel;
    }

    void updateKC(int data) {
        this.total.setText(QuantityFormatter.quantityToStackSize((long)data));
    }
}

