/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.storage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.raidsdrymeter.storage.RaidRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecordWriter {
    private static final Logger log = LoggerFactory.getLogger(RecordWriter.class);
    private static final String FILE_EXTENSION = ".log";
    private static final File LOOT_RECORD_DIR = new File(RuneLite.RUNELITE_DIR, "raids-dry-meter");
    private File playerFolder = LOOT_RECORD_DIR;
    private final Map<LootRecordType, File> eventFolders = new HashMap<LootRecordType, File>();
    private String name;

    @Inject
    public RecordWriter() {
        LOOT_RECORD_DIR.mkdir();
    }

    public void setPlayerUsername(String username) {
        if (username.equalsIgnoreCase(this.name)) {
            return;
        }
        this.playerFolder = new File(LOOT_RECORD_DIR, username);
        this.playerFolder.mkdir();
        this.name = username;
        this.createSubFolders();
    }

    private void createSubFolders() {
        this.eventFolders.clear();
        for (LootRecordType type : LootRecordType.values()) {
            if (type.name() != "EVENT") continue;
            File folder = new File(this.playerFolder, type.name().toLowerCase());
            folder.mkdir();
            this.eventFolders.put(type, folder);
        }
    }

    private static String raidNameToFileName(String raidName) {
        return raidName.toLowerCase().trim() + FILE_EXTENSION;
    }

    public SetMultimap<LootRecordType, String> getKnownFileNames() {
        HashMultimap fileNames = HashMultimap.create();
        for (Map.Entry<LootRecordType, File> entry : this.eventFolders.entrySet()) {
            File[] files = entry.getValue().listFiles((dir, name) -> name.endsWith(FILE_EXTENSION));
            if (files == null) continue;
            for (File f : files) {
                fileNames.put((Object)entry.getKey(), (Object)f.getName().replace(FILE_EXTENSION, ""));
            }
        }
        return fileNames;
    }

    public synchronized Collection<RaidRecord> loadRaidTrackerRecords(LootRecordType recordType, String npcName) {
        return this.loadRaidTrackerRecords(npcName, this.eventFolders.get(recordType));
    }

    @Deprecated
    public synchronized Collection<RaidRecord> loadRaidTrackerRecords(String npcName, File folder) {
        String fileName = RecordWriter.raidNameToFileName(npcName);
        File file = new File(folder, fileName);
        ArrayList<RaidRecord> data = new ArrayList<RaidRecord>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                RaidRecord r = (RaidRecord)RuneLiteAPI.GSON.fromJson(line, RaidRecord.class);
                data.add(r);
            }
        }
        catch (FileNotFoundException e) {
            log.debug("File not found: {}", (Object)fileName);
        }
        catch (IOException e) {
            log.warn("IOException for file {}: {}", (Object)fileName, (Object)e.getMessage());
        }
        return data;
    }

    public synchronized boolean addRaidRecord(RaidRecord rec) {
        if (rec.getName().equals("Chambers of Xeric") || rec.getName().equals("Theater of Blood")) {
            String fileName = RecordWriter.raidNameToFileName(rec.getName());
            File lootFile = new File(this.eventFolders.get(rec.getType()), fileName);
            String dataAsString = RuneLiteAPI.GSON.toJson((Object)rec);
            try {
                BufferedWriter file = new BufferedWriter(new FileWriter(String.valueOf(lootFile), true));
                file.append(dataAsString);
                file.newLine();
                file.close();
                return true;
            }
            catch (IOException ioe) {
                log.warn("Error writing loot data to file {}: {}", (Object)fileName, (Object)ioe.getMessage());
                return false;
            }
        }
        return false;
    }
}

