/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.data;

import com.raidsdrymeter.data.UniqueItem;
import com.raidsdrymeter.storage.RaidRecord;
import com.raidsdrymeter.storage.UniqueEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.runelite.http.api.loottracker.LootRecordType;

public class UniqueLog {
    private final String name;
    private final LootRecordType type;
    private final List<RaidRecord> records = new ArrayList<RaidRecord>();
    private final Map<Integer, UniqueEntry> consolidated = new HashMap<Integer, UniqueEntry>();
    private final Collection<UniqueItem> uniques;

    public UniqueLog(Collection<RaidRecord> records, String name) {
        this.records.addAll(records);
        this.name = name;
        if (records.size() == 0) {
            this.type = LootRecordType.UNKNOWN;
        } else {
            RaidRecord record = this.records.get(0);
            this.type = record.getType();
        }
        for (RaidRecord record : records) {
            for (UniqueEntry entry : record.getUniques()) {
                this.addItemEntryToMap(entry);
            }
        }
        Collection<UniqueItem> unsorted = UniqueItem.getUniquesForBoss(name);
        if (unsorted == null) {
            this.uniques = new ArrayList<UniqueItem>();
            return;
        }
        this.uniques = unsorted.stream().sorted(Comparator.comparingInt(UniqueItem::getPosition)).collect(Collectors.toList());
    }

    public synchronized void addRecord(RaidRecord record) {
        this.records.add(record);
        for (UniqueEntry entry : record.getUniques()) {
            this.addItemEntryToMap(entry);
        }
    }

    private void addItemEntryToMap(UniqueEntry unique) {
        UniqueEntry oldEntry;
        String itemNameLowercased = unique.getName().toLowerCase();
        if (this.type != null) {
            unique = new UniqueEntry(unique.getName(), unique.getId(), unique.getQuantity(), unique.getPrice());
        }
        if ((oldEntry = this.consolidated.get(unique.getId())) != null) {
            oldEntry.setQuantity(oldEntry.getQuantity() + unique.getQuantity());
        } else {
            this.consolidated.put(unique.getId(), new UniqueEntry(unique.getName(), unique.getId(), unique.getQuantity(), unique.getPrice()));
        }
    }

    public String getName() {
        return this.name;
    }

    public LootRecordType getType() {
        return this.type;
    }

    public List<RaidRecord> getRecords() {
        return this.records;
    }

    public Map<Integer, UniqueEntry> getConsolidated() {
        return this.consolidated;
    }

    public Collection<UniqueItem> getUniques() {
        return this.uniques;
    }
}

