/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.data;

import com.google.common.collect.ImmutableMultimap;
import com.raidsdrymeter.data.RaidTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

public enum UniqueItem {
    ARCANE_PRAYER_SCROLL(21079, RaidTab.COX, 0, 0.14495),
    DEXTEROUS_PRAYER_SCROLL(21034, RaidTab.COX, 0, 0.14495),
    TWISTED_BUCKLER(21000, RaidTab.COX, 0, 0.029),
    DRAGON_HUNTER_CROSSBOW(21012, RaidTab.COX, 0, 0.029),
    DINHS_BULWARK(21015, RaidTab.COX, 1, 0.0087),
    ANCESTRAL_HAT(21018, RaidTab.COX, 1, 0.0087),
    ANCESTRAL_ROBE_TOP(21021, RaidTab.COX, 1, 0.0087),
    ANCESTRAL_ROBE_BOTTOM(21024, RaidTab.COX, 1, 0.0087),
    DRAGON_CLAWS(13652, RaidTab.COX, 2, 0.0087),
    ELDER_MAUL(21003, RaidTab.COX, 2, 0.00966666),
    KODAI_INSIGNIA(21043, RaidTab.COX, 2, 0.00966666),
    TWISTED_BOW(20997, RaidTab.COX, 2, 0.00966666),
    AVERNIC_DEFENDER_HILT(22477, RaidTab.TOB, 0, 0.0463),
    GHRAZI_RAPIER(22324, RaidTab.TOB, 0, 0.0),
    SANGUINESTI_STAFF(22481, RaidTab.TOB, 0, 0.42105263157894735),
    JUSTICIAR_FACEGUARD(22326, RaidTab.TOB, 0, 0.10526315789473684),
    JUSTICIAR_CHESTGUARD(22327, RaidTab.TOB, 1, 0.10526315789473684),
    JUSTICIAR_LEGUARDS(22328, RaidTab.TOB, 1, 0.10526315789473684),
    SCYTHE_OF_VITUR(22325, RaidTab.TOB, 1, 0.05263157894736842);

    private int itemID;
    private RaidTab[] raids;
    private int position;
    private double dropRate;
    private String name;
    private int price;
    private int linkedID;
    private int qty;
    private static final ImmutableMultimap<String, UniqueItem> RAID_MAP;

    private UniqueItem(int id, RaidTab raid, int position, double dropRate) {
        this.itemID = id;
        this.raids = new RaidTab[]{raid};
        this.position = position;
        this.dropRate = dropRate;
    }

    public static void prepareUniqueItems(ItemManager itemManager) {
        for (UniqueItem item : UniqueItem.values()) {
            if (item.getName() != null) {
                return;
            }
            ItemComposition c = itemManager.getItemComposition(item.getItemID());
            item.name = c.getName();
            item.linkedID = c.getLinkedNoteId();
            item.price = itemManager.getItemPrice(c.getId());
        }
    }

    public static List<Integer> getUniqueItemList(ItemManager itemManager) {
        ArrayList<Integer> uniques = new ArrayList<Integer>();
        for (UniqueItem item : UniqueItem.values()) {
            uniques.add(item.getItemID());
        }
        return uniques;
    }

    public static Collection<UniqueItem> getUniquesForBoss(String raidName) {
        return RAID_MAP.get((Object)raidName);
    }

    private UniqueItem() {
    }

    public int getItemID() {
        return this.itemID;
    }

    public RaidTab[] getRaids() {
        return this.raids;
    }

    public int getPosition() {
        return this.position;
    }

    public double getDropRate() {
        return this.dropRate;
    }

    public String getName() {
        return this.name;
    }

    public int getPrice() {
        return this.price;
    }

    public int getLinkedID() {
        return this.linkedID;
    }

    public int getQty() {
        return this.qty;
    }

    public void setQty(int qty) {
        this.qty = qty;
    }

    static {
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        for (UniqueItem item : UniqueItem.values()) {
            for (RaidTab b : item.getRaids()) {
                map.put((Object)b.getName(), (Object)item);
            }
        }
        RAID_MAP = map.build();
    }
}

