/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import net.runelite.http.api.loottracker.LootRecordType;

public enum RaidTab {
    COX("Chambers of Xeric", 20851, "Raids", LootRecordType.EVENT),
    TOB("Theater of Blood", 22473, "Raids", LootRecordType.EVENT);

    private final String name;
    private final int itemID;
    private final String category;
    private final LootRecordType type;
    private static final Map<String, RaidTab> NAME_MAP;
    private static final Multimap<String, RaidTab> CATEGORY_MAP;

    public static RaidTab getByName(String name) {
        return NAME_MAP.get(name.toUpperCase());
    }

    public static Collection<RaidTab> getByCategoryName(String name) {
        return CATEGORY_MAP.get((Object)name);
    }

    public String getName() {
        return this.name;
    }

    public int getItemID() {
        return this.itemID;
    }

    public String getCategory() {
        return this.category;
    }

    public LootRecordType getType() {
        return this.type;
    }

    private RaidTab(String name, int itemID, String category, LootRecordType type) {
        this.name = name;
        this.itemID = itemID;
        this.category = category;
        this.type = type;
    }

    static {
        ImmutableMap.Builder byName = ImmutableMap.builder();
        ImmutableMultimap.Builder categoryMap = ImmutableMultimap.builder();
        for (RaidTab tab : RaidTab.values()) {
            byName.put((Object)tab.getName().toUpperCase(), (Object)tab);
            categoryMap.put((Object)tab.getCategory(), (Object)tab);
        }
        NAME_MAP = byName.build();
        CATEGORY_MAP = categoryMap.build();
    }
}

