/*
 * Decompiled with CFR 0.152.
 */
package com.raidsdrymeter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.raidsdrymeter.data.RaidTab;
import com.raidsdrymeter.data.UniqueItem;
import com.raidsdrymeter.data.UniqueLog;
import com.raidsdrymeter.storage.RaidRecord;
import com.raidsdrymeter.storage.RecordWriter;
import com.raidsdrymeter.storage.UniqueEntry;
import com.raidsdrymeter.ui.RaidsDryMeterPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.loottracker.LootRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dry Meter for Raids", description="Tracks how dry you are while raiding with different group sizes")
public class RaidsDryMeterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidsDryMeterPlugin.class);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([0-9]+)");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private RecordWriter writer;
    String raidType;
    private RaidsDryMeterPanel panel;
    private NavigationButton navButton;
    private SetMultimap<LootRecordType, String> lootNames = HashMultimap.create();
    boolean personalUnique = false;
    boolean teamUnique = false;
    int partySize = 0;
    List<RaidRecord> records;
    private boolean prepared = false;
    private Map<String, Integer> killCountMap = new HashMap<String, Integer>();

    protected void startUp() throws Exception {
        this.panel = new RaidsDryMeterPanel(this, this.itemManager);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/util/dry_raids_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Dry Meter for Raids").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (!this.prepared) {
            this.prepared = true;
            this.clientThread.invokeLater(() -> {
                switch (this.client.getGameState()) {
                    case UNKNOWN: 
                    case STARTING: {
                        return false;
                    }
                }
                UniqueItem.prepareUniqueItems(this.itemManager);
                return true;
            });
        }
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN) || this.client.getGameState().equals((Object)GameState.LOADING)) {
            this.updateWriterUsername();
        }
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.updateWriterUsername();
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived event) {
        if (event.getName().equals("Chambers of Xeric")) {
            int teamRaidsDry;
            int personalRaidsDry;
            this.partySize = this.client.getPlayers().size();
            Collection<UniqueEntry> drops = this.convertToUniqueRecords(event.getItems());
            int totalPoints = this.client.getVar(5431);
            int personalPoints = this.client.getVar(5422);
            for (int uniqueId : UniqueItem.getUniqueItemList(this.itemManager)) {
                for (ItemStack item : event.getItems()) {
                    if (item.getId() != uniqueId) continue;
                    this.personalUnique = true;
                }
            }
            this.records = new ArrayList<RaidRecord>(this.getDataByName(event.getType(), event.getName()));
            if (this.records.size() == 0) {
                personalRaidsDry = 0;
                teamRaidsDry = 0;
            } else {
                int index = this.records.size() - 1;
                personalRaidsDry = this.records.get(index).getPersonalRaidsDry();
                teamRaidsDry = this.records.get(index).getTeamRaidsDry();
            }
            personalRaidsDry = this.personalUnique ? 0 : ++personalRaidsDry;
            teamRaidsDry = this.teamUnique ? 0 : ++teamRaidsDry;
            int kc = this.killCountMap.getOrDefault(event.getName().toUpperCase(), -1);
            RaidRecord record = new RaidRecord(event.getName(), kc, this.partySize, personalPoints, totalPoints, personalRaidsDry, teamRaidsDry, 0, 0, event.getType(), drops);
            this.addRecord(record);
            this.personalUnique = false;
            this.teamUnique = false;
            SwingUtilities.invokeLater(() -> this.panel.refreshUI());
        }
    }

    private void setRaidType(String raidType) {
        this.raidType = raidType;
    }

    private void updateWriterUsername() {
        this.writer.setPlayerUsername(this.client.getUsername());
        this.localPlayerNameChanged();
    }

    private void localPlayerNameChanged() {
        this.lootNames = this.writer.getKnownFileNames();
        SwingUtilities.invokeLater(() -> this.panel.refreshUI());
    }

    private Collection<UniqueEntry> convertToUniqueRecords(Collection<ItemStack> stacks) {
        return stacks.stream().map(i -> this.createUniqueRecord(i.getId(), i.getQuantity())).collect(Collectors.toList());
    }

    private UniqueEntry createUniqueRecord(int id, int qty) {
        ItemComposition c = this.itemManager.getItemComposition(id);
        int realId = c.getNote() == -1 ? c.getId() : c.getLinkedNoteId();
        int price = this.itemManager.getItemPrice(realId);
        return new UniqueEntry(c.getName(), id, qty, price);
    }

    private void addRecord(RaidRecord record) {
        this.writer.addRaidRecord(record);
        this.lootNames.put((Object)record.getType(), (Object)record.getName().toLowerCase());
        SwingUtilities.invokeLater(() -> this.panel.addLog(record));
    }

    public void requestUniqueLog(LootRecordType type, String name) {
        this.clientThread.invoke(() -> {
            Collection<RaidRecord> records = this.getDataByName(type, name);
            UniqueLog log = new UniqueLog(records, name);
            SwingUtilities.invokeLater(() -> this.panel.useLog(log));
        });
    }

    public Collection<RaidRecord> getDataByName(LootRecordType type, String name) {
        RaidTab tab = RaidTab.getByName(name);
        if (tab != null) {
            name = tab.getName();
        }
        return this.writer.loadRaidTrackerRecords(type, name);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher n;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMessage = Text.removeTags((String)event.getMessage());
        if (chatMessage.startsWith("Your completed Chambers of Xeric count is") && (n = NUMBER_PATTERN.matcher(chatMessage)).find()) {
            this.killCountMap.put("CHAMBERS OF XERIC", Integer.valueOf(n.group()));
            return;
        }
        if (chatMessage.startsWith("Your completed Theatre of Blood count is") && (n = NUMBER_PATTERN.matcher(chatMessage)).find()) {
            this.killCountMap.put("THEATRE OF BLOOD", Integer.valueOf(n.group()));
            return;
        }
        if (chatMessage.startsWith("Special loot:")) {
            this.teamUnique = true;
        }
    }

    public SetMultimap<LootRecordType, String> getLootNames() {
        return this.lootNames;
    }
}

