/*
 * Decompiled with CFR 0.152.
 */
package com.westerhoud.osrs.taskman.ui;

import com.westerhoud.osrs.taskman.TaskmanPlugin;
import com.westerhoud.osrs.taskman.domain.AccountProgress;
import com.westerhoud.osrs.taskman.domain.Task;
import com.westerhoud.osrs.taskman.domain.TierProgress;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ColorJButton;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.ui.components.ProgressBar;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskmanPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TaskmanPluginPanel.class);
    private final TaskmanPlugin taskmanPlugin;
    private final JPanel taskPanel;
    private final JPanel taskDataPanel;
    private final JPanel progressPanel;
    private final PluginErrorPanel errorPanel;
    private final JShadowedLabel currentTaskLabel = new JShadowedLabel("Current task:");
    private final JShadowedLabel progressLabel = new JShadowedLabel("Progress:");
    private final JShadowedLabel imageLabel = new JShadowedLabel();
    private final JShadowedLabel nameLabel = new JShadowedLabel();
    private final JButton refreshButton = new JButton();
    private final ColorJButton generateButton = new ColorJButton("Generate task", ColorScheme.DARK_GRAY_COLOR);
    private final ColorJButton completeButton = new ColorJButton("Complete task", ColorScheme.DARK_GRAY_COLOR);
    private final JPanel tryAgainPanel;

    public TaskmanPluginPanel(TaskmanPlugin taskmanPlugin) {
        this.taskmanPlugin = taskmanPlugin;
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(50, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.taskPanel = new JPanel(new BorderLayout(10, 10));
        this.taskPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.taskPanel.setVisible(false);
        this.taskDataPanel = new JPanel(new BorderLayout(10, 5));
        JPanel taskDataTitlePanel = new JPanel(new BorderLayout());
        this.currentTaskLabel.setFont(FontManager.getRunescapeFont());
        this.currentTaskLabel.setForeground(Color.WHITE);
        this.refreshButton.setIcon(this.getRefreshButton());
        this.refreshButton.setPreferredSize(new Dimension(25, 25));
        this.refreshButton.setMaximumSize(new Dimension(25, 25));
        this.refreshButton.setFocusPainted(false);
        this.refreshButton.addActionListener(e -> this.reset());
        taskDataTitlePanel.add((Component)this.currentTaskLabel, "West");
        taskDataTitlePanel.add((Component)this.refreshButton, "East");
        this.nameLabel.setFont(FontManager.getRunescapeSmallFont());
        this.nameLabel.setHorizontalAlignment(2);
        this.taskDataPanel.add((Component)taskDataTitlePanel, "North");
        this.taskDataPanel.add((Component)this.imageLabel, "West");
        this.taskDataPanel.add((Component)this.nameLabel, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout(10, 10));
        this.generateButton.setFont(FontManager.getRunescapeSmallFont());
        this.generateButton.setFocusPainted(false);
        this.generateButton.addActionListener(e -> this.generateTaskAndUpdateContent());
        this.completeButton.setFont(FontManager.getRunescapeSmallFont());
        this.completeButton.setFocusPainted(false);
        this.completeButton.addActionListener(e -> this.completeTaskAndUpdateContent());
        buttonPanel.add((Component)this.generateButton, "West");
        buttonPanel.add((Component)this.completeButton, "Center");
        this.progressPanel = new JPanel(new GridLayout(5, 1, 10, 10));
        this.progressPanel.setBorder(new EmptyBorder(30, 10, 0, 10));
        this.progressPanel.setVisible(false);
        this.progressLabel.setFont(FontManager.getRunescapeFont());
        this.progressLabel.setForeground(Color.WHITE);
        this.taskPanel.add((Component)this.taskDataPanel, "North");
        this.taskPanel.add((Component)buttonPanel, "Center");
        this.taskPanel.add((Component)this.progressPanel, "South");
        this.errorPanel = new PluginErrorPanel();
        this.errorPanel.setBorder((Border)new EmptyBorder(50, 0, 0, 0));
        this.tryAgainPanel = new JPanel();
        JButton tryAgainButton = new JButton("Try again");
        tryAgainButton.setFocusPainted(false);
        tryAgainButton.addActionListener(e -> this.reset());
        tryAgainButton.setPreferredSize(new Dimension(100, 25));
        tryAgainButton.setMaximumSize(new Dimension(150, 25));
        this.tryAgainPanel.add(tryAgainButton);
        this.tryAgainPanel.setVisible(false);
        this.errorPanel.add((Component)this.tryAgainPanel, (Object)"South");
        this.errorPanel.setContent("Please login first!", "");
        this.add(this.taskPanel, "North");
        this.add(this.progressPanel, "Center");
        this.add((Component)this.errorPanel, "South");
    }

    public void init() {
        this.reset();
    }

    private void updateTaskPanelContent(Task task) {
        this.imageLabel.setIcon((Icon)new ImageIcon(task.getResizedImage(25, 25)));
        this.nameLabel.setText(task.getName());
        this.taskPanel.setVisible(true);
    }

    private void showErrorMessage(Exception e) {
        this.tryAgainPanel.setVisible(true);
        this.errorPanel.setContent("Oops... Something went wrong", e.getMessage());
        this.errorPanel.setVisible(true);
        this.errorPanel.revalidate();
        this.errorPanel.repaint();
    }

    private void getCurrentTaskAndUpdateContent() {
        try {
            Task currentTask = this.taskmanPlugin.getCurrentTask();
            this.updateTaskPanelContent(currentTask);
            this.errorPanel.setVisible(false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.showErrorMessage(e);
        }
    }

    private void generateTaskAndUpdateContent() {
        try {
            Task newTask = this.taskmanPlugin.generateTask();
            this.updateTaskPanelContent(newTask);
            this.errorPanel.setVisible(false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.showErrorMessage(e);
        }
    }

    private void completeTaskAndUpdateContent() {
        try {
            Task newTask = this.taskmanPlugin.completeTask();
            this.updateTaskPanelContent(newTask);
            this.getProgressAndUpdateContent();
            this.errorPanel.setVisible(false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.showErrorMessage(e);
        }
    }

    private void getProgressAndUpdateContent() {
        try {
            AccountProgress accountProgress = this.taskmanPlugin.progress();
            this.progressPanel.removeAll();
            this.progressPanel.add((Component)this.progressLabel);
            for (Map.Entry<String, TierProgress> entry : accountProgress.getProgressByTier().entrySet()) {
                String key = entry.getKey();
                TierProgress value = entry.getValue();
                ProgressBar progressBar = new ProgressBar();
                progressBar.setMaximumValue(value.getMaxValue());
                progressBar.setValue(value.getValue());
                progressBar.setRightLabel(String.valueOf(value.getMaxValue()));
                progressBar.setLeftLabel(String.valueOf(value.getValue()));
                int percentage = progressBar.getPercentage();
                progressBar.setCenterLabel(String.format("%s %d%%", key, percentage));
                progressBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                if (percentage == 0) {
                    progressBar.setForeground(Color.RED);
                } else if (percentage < 25) {
                    progressBar.setForeground(Color.decode("#ea6600"));
                } else if (percentage < 50) {
                    progressBar.setForeground(Color.decode("#ffb600"));
                } else if (percentage < 75) {
                    progressBar.setForeground(Color.decode("#ffe500"));
                } else if (percentage < 100) {
                    progressBar.setForeground(Color.decode("#aeff00"));
                } else {
                    progressBar.setForeground(Color.GREEN);
                }
                this.progressPanel.add((Component)progressBar);
            }
            if (!accountProgress.getProgressByTier().isEmpty()) {
                this.progressPanel.setVisible(true);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.showErrorMessage(e);
        }
    }

    private Icon getRefreshButton() {
        BufferedImage image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"refresh.png");
        Image resizedImage = image.getScaledInstance(25, 25, 2);
        return new ImageIcon(resizedImage);
    }

    public void reset() {
        this.taskPanel.setVisible(false);
        this.progressPanel.setVisible(false);
        this.getCurrentTaskAndUpdateContent();
        this.getProgressAndUpdateContent();
    }

    public void onLogout() {
        this.taskPanel.setVisible(false);
        this.progressPanel.setVisible(false);
        this.tryAgainPanel.setVisible(false);
        this.errorPanel.setContent("Please login first!", "");
        this.errorPanel.setVisible(true);
        this.errorPanel.revalidate();
        this.errorPanel.repaint();
    }
}

