/*
 * Decompiled with CFR 0.152.
 */
package com.westerhoud.osrs.taskman.service;

import com.google.gson.Gson;
import com.westerhoud.osrs.taskman.domain.AccountCredentials;
import com.westerhoud.osrs.taskman.domain.AccountProgress;
import com.westerhoud.osrs.taskman.domain.ErrorResponse;
import com.westerhoud.osrs.taskman.domain.Task;
import com.westerhoud.osrs.taskman.domain.TaskmanCommandData;
import java.io.IOException;
import javax.imageio.ImageIO;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskService
implements com.westerhoud.osrs.taskman.api.TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskService.class);
    public static final String TASKMAN_IDENTIFIER_HEADER = "x-taskman-identifier";
    public static final String TASKMAN_PASSWORD_HEADER = "x-taskman-password";
    public static final String TASKMAN_SOURCE_HEADER = "x-taskman-source";
    public static final String TASKMAN_RSN_HEADER = "x-taskman-rsn";
    private static final String BASE_URL = "https://taskman.up.railway.app/task";
    private final OkHttpClient client;
    private final Gson gson;
    private final String currentUrl;
    private final String generateUrl;
    private final String completeUrl;
    private final String progressUrl;
    private final String commandUrl;

    public TaskService(OkHttpClient okHttpClient, Gson gson) {
        this.client = okHttpClient;
        this.gson = gson;
        this.currentUrl = "https://taskman.up.railway.app/task/current";
        this.generateUrl = "https://taskman.up.railway.app/task/generate";
        this.completeUrl = "https://taskman.up.railway.app/task/complete";
        this.progressUrl = "https://taskman.up.railway.app/task/progress";
        this.commandUrl = "https://taskman.up.railway.app/task/command/%s";
    }

    @Override
    public Task getCurrentTask(AccountCredentials credentials, String rsn) throws IOException {
        if (!credentials.isValid()) {
            throw new IllegalArgumentException("Please configure your credentials in the plugin configurations");
        }
        Request request = new Request.Builder().url(this.currentUrl).addHeader(TASKMAN_IDENTIFIER_HEADER, credentials.getIdentifier()).addHeader(TASKMAN_PASSWORD_HEADER, credentials.getPassword()).addHeader(TASKMAN_SOURCE_HEADER, credentials.getSource().name()).addHeader(TASKMAN_RSN_HEADER, rsn).get().build();
        return this.executeRequest(request);
    }

    @Override
    public Task generateTask(AccountCredentials credentials, String rsn) throws IOException {
        Request request = new Request.Builder().url(this.generateUrl).header("Content-Type", "application/json").addHeader(TASKMAN_SOURCE_HEADER, credentials.getSource().name()).addHeader(TASKMAN_RSN_HEADER, rsn).post(this.getRequestBody(credentials)).build();
        return this.executeRequest(request);
    }

    @Override
    public Task completeTask(AccountCredentials credentials, String rsn) throws IOException {
        Request request = new Request.Builder().url(this.completeUrl).header("Content-Type", "application/json").addHeader(TASKMAN_SOURCE_HEADER, credentials.getSource().name()).addHeader(TASKMAN_RSN_HEADER, rsn).post(this.getRequestBody(credentials)).build();
        return this.executeRequest(request);
    }

    @Override
    public AccountProgress getAccountProgress(AccountCredentials credentials, String rsn) throws IOException {
        if (!credentials.isValid()) {
            throw new IllegalArgumentException("Please set your username / spreadsheet key in the plugin configurations");
        }
        Request request = new Request.Builder().url(this.progressUrl).addHeader(TASKMAN_IDENTIFIER_HEADER, credentials.getIdentifier()).addHeader(TASKMAN_PASSWORD_HEADER, credentials.getPassword()).addHeader(TASKMAN_SOURCE_HEADER, credentials.getSource().name()).addHeader(TASKMAN_RSN_HEADER, rsn).get().build();
        Response response = this.client.newCall(request).execute();
        if (response.code() == 200) {
            return (AccountProgress)this.gson.fromJson(response.body().string(), AccountProgress.class);
        }
        ErrorResponse error = this.mapResponseToErrorResponse(response);
        throw new IllegalArgumentException(error.getMessage());
    }

    @Override
    public TaskmanCommandData getChatCommandData(String rsn) throws IOException {
        Request request = new Request.Builder().url(String.format(this.commandUrl, rsn)).get().build();
        Response response = this.client.newCall(request).execute();
        if (response.code() == 200) {
            return (TaskmanCommandData)this.gson.fromJson(response.body().string(), TaskmanCommandData.class);
        }
        throw new IllegalArgumentException("Could not get task command data for rsn: " + rsn);
    }

    private RequestBody getRequestBody(AccountCredentials credentials) {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.gson.toJson((Object)credentials));
    }

    private Task executeRequest(Request request) throws IOException {
        Response response = this.client.newCall(request).execute();
        if (response.code() == 200) {
            Task task = this.mapResponseToTask(response);
            this.setImage(task);
            return task;
        }
        ErrorResponse error = this.mapResponseToErrorResponse(response);
        throw new IllegalArgumentException(error.getMessage());
    }

    private Task mapResponseToTask(Response response) throws IOException {
        return (Task)this.gson.fromJson(response.body().string(), Task.class);
    }

    private ErrorResponse mapResponseToErrorResponse(Response response) throws IOException {
        String responseString = response.body().string();
        log.error(responseString);
        return (ErrorResponse)this.gson.fromJson(responseString, ErrorResponse.class);
    }

    private void setImage(Task task) {
        Request request = new Request.Builder().url(task.getImageUrl()).get().build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                log.info(task.getImageUrl());
                return;
            }
            task.setImage(ImageIO.read(responseBody.byteStream()));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

