/*
 * Decompiled with CFR 0.152.
 */
package com.westerhoud.osrs.taskman.domain;

import java.awt.Image;
import java.awt.image.BufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    private static final BufferedImage ERROR_IMAGE = ImageUtil.loadImageResource(Task.class, (String)"error.png");
    private String name;
    private String imageUrl;
    private transient BufferedImage image;

    public String getImageUrl() {
        return this.imageUrl.startsWith("http://") ? this.imageUrl.replace("http://", "https://") : this.imageUrl;
    }

    public Image getResizedImage(int width, int height) {
        if (this.image != null) {
            return this.image.getScaledInstance(width, height, 2);
        }
        return ERROR_IMAGE.getScaledInstance(width, height, 2);
    }

    public String getName() {
        return this.name;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        return !(this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        return result;
    }

    public String toString() {
        return "Task(name=" + this.getName() + ", imageUrl=" + this.getImageUrl() + ", image=" + this.getImage() + ")";
    }
}

