/*
 * Decompiled with CFR 0.152.
 */
package com.westerhoud.osrs.taskman;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.westerhoud.osrs.taskman.TaskmanConfig;
import com.westerhoud.osrs.taskman.domain.AccountCredentials;
import com.westerhoud.osrs.taskman.domain.AccountProgress;
import com.westerhoud.osrs.taskman.domain.Task;
import com.westerhoud.osrs.taskman.domain.TaskmanCommandData;
import com.westerhoud.osrs.taskman.service.TaskService;
import com.westerhoud.osrs.taskman.ui.CurrentTaskOverlay;
import com.westerhoud.osrs.taskman.ui.TaskmanPluginPanel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Taskman")
public class TaskmanPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TaskmanPlugin.class);
    private static final String TASKMAN_CONFIG_GROUP = "taskman";
    private static final String TASKMAN_CHAT_COMMAND = "!taskman";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private TaskmanConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CurrentTaskOverlay currentTaskOverlay;
    @Inject
    private ChatCommandManager chatCommandManager;
    private TaskmanPluginPanel sidePanel;
    private TaskService taskService;
    private NavigationButton navigationButton;
    private boolean loggedIn = false;
    private boolean sidePanelInitialized = false;

    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.taskService = new TaskService(this.okHttpClient, this.gson);
        this.chatCommandManager.registerCommandAsync(TASKMAN_CHAT_COMMAND, this::getTaskmanCommandData);
        this.sidePanel = new TaskmanPluginPanel(this);
        this.navigationButton = NavigationButton.builder().tooltip("Taskman").priority(8).icon(icon).panel((PluginPanel)this.sidePanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.overlayManager.add((Overlay)this.currentTaskOverlay);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.overlayManager.remove((Overlay)this.currentTaskOverlay);
        this.chatCommandManager.unregisterCommand(TASKMAN_CHAT_COMMAND);
    }

    public Task getCurrentTask() throws Exception {
        Task task = this.taskService.getCurrentTask(this.getCredentials(), this.getRsn());
        this.currentTaskOverlay.setTask(task);
        return task;
    }

    public Task generateTask() throws Exception {
        Task task = this.taskService.generateTask(this.getCredentials(), this.getRsn());
        this.currentTaskOverlay.setTask(task);
        return task;
    }

    public Task completeTask() throws Exception {
        Task task = this.taskService.completeTask(this.getCredentials(), this.getRsn());
        this.currentTaskOverlay.setTask(task);
        return task;
    }

    public AccountProgress progress() throws Exception {
        return this.taskService.getAccountProgress(this.getCredentials(), this.getRsn());
    }

    private void getTaskmanCommandData(ChatMessage chatMessage, String message) {
        TaskmanCommandData data;
        if (!this.config.taskmanCommand()) {
            return;
        }
        ChatMessageType type = chatMessage.getType();
        String rsn = type == ChatMessageType.PRIVATECHATOUT ? this.getRsn() : Text.removeTags((String)chatMessage.getName()).replace('\u00a0', ' ');
        try {
            data = this.taskService.getChatCommandData(rsn);
        }
        catch (IOException ex) {
            log.debug("Unable to get chat command data", (Throwable)ex);
            return;
        }
        String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Progress: ").append(ChatColorType.HIGHLIGHT).append(data.getProgressPercentage() + "% " + data.getTier()).append(ChatColorType.NORMAL).append(" Current task: ").append(ChatColorType.HIGHLIGHT).append(data.getTask().getName()).build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }

    private AccountCredentials getCredentials() {
        switch (this.config.taskSource()) {
            case SPREADSHEET: {
                return new AccountCredentials(this.config.spreadsheetKey(), this.config.passphrase(), this.config.taskSource());
            }
            case WEBSITE: {
                return new AccountCredentials(this.config.websiteUsername(), this.config.websitePassword(), this.config.taskSource());
            }
        }
        throw new IllegalArgumentException("No task source selected in config.");
    }

    private String getRsn() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            throw new IllegalArgumentException("Please login first!");
        }
        return player.getName();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loggedIn = true;
        } else if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.loggedIn = false;
            this.sidePanelInitialized = false;
            this.sidePanel.onLogout();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.sidePanelInitialized && this.loggedIn) {
            log.info("Initializing sidepanel");
            this.sidePanel.init();
            this.sidePanelInitialized = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals(TASKMAN_CONFIG_GROUP)) {
            log.info("Configuration changed");
            SwingUtilities.invokeLater(() -> this.sidePanel.reset());
        }
    }

    @Provides
    TaskmanConfig provideConfig(ConfigManager configManager) {
        return (TaskmanConfig)configManager.getConfig(TaskmanConfig.class);
    }
}

