/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit.clanmemberlistsort;

import com.google.inject.Provides;
import eu.jodelahithit.clanmemberlistsort.ClanMemberListEntry;
import eu.jodelahithit.clanmemberlistsort.ClanMemberListSortConfig;
import eu.jodelahithit.clanmemberlistsort.SortType;
import eu.jodelahithit.clanmemberlistsort.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Clan Member List Sorting", description="Adds a sort button to the clan member list", tags={"clan", "members", "list", "sorting", "alphabetically", "world", "rank", "role"})
public class ClanMemberListSortPlugin
extends Plugin {
    static final String CONFIG_GROUP = "clanmemberlistsorting";
    final int WIDGET_HEIGHT = 15;
    final int UNK_CLAN_TAB_SCRIPT = 2859;
    private Widget clanMemberListHeaderWidget;
    private Widget clanMemberListsWidget;
    private Widget sortButton;
    @Inject
    Client client;
    @Inject
    ClientThread clientThread;
    @Inject
    ClanMemberListSortConfig config;

    @Provides
    ClanMemberListSortConfig getConfig(ConfigManager configManager) {
        return (ClanMemberListSortConfig)configManager.getConfig(ClanMemberListSortConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals(CONFIG_GROUP) && configChanged.getKey().equals("reverseSort")) {
            this.updateSortButtonSprite();
        }
    }

    public void startUp() {
        this.clientThread.invokeLater(this::initWidgets);
    }

    public void shutDown() {
        if (this.clanMemberListHeaderWidget != null) {
            this.clanMemberListHeaderWidget.deleteAllChildren();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == WidgetInfo.CLAN_MEMBER_LIST.getGroupId()) {
            this.initWidgets();
        }
    }

    private Widget GetOnOpListenerWidgetFromName(Widget[] widgets, String name) {
        for (int i = 0; i < widgets.length; ++i) {
            if (widgets[i].getOnOpListener() == null || Utils.removeDecorationsFromString(widgets[i].getName()).compareTo(name) != 0) continue;
            return widgets[i];
        }
        return null;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 2859) {
            return;
        }
        if (this.clanMemberListsWidget == null) {
            return;
        }
        ArrayList<ClanMemberListEntry> entries = new ArrayList<ClanMemberListEntry>();
        Widget[] widgets = this.clanMemberListsWidget.getChildren();
        if (widgets == null) {
            return;
        }
        for (int i = 0; i < widgets.length - 3; ++i) {
            int firstType = widgets[i].getType();
            if (firstType != 3 && firstType != 5 || widgets[i + 1].getType() != 4 || widgets[i + 2].getType() != 4 || widgets[i + 3].getType() != 5) continue;
            entries.add(new ClanMemberListEntry(this.GetOnOpListenerWidgetFromName(widgets, widgets[i + 1].getText()), widgets[i + 1], widgets[i + 2], widgets[i + 3]));
        }
        Comparator<ClanMemberListEntry> comparator = null;
        switch (this.config.activeSortType()) {
            case SORT_BY_WORLD: {
                comparator = Comparator.comparing(ClanMemberListEntry::getWorld);
                break;
            }
            case SORT_BY_NAME: {
                comparator = Comparator.comparing(ClanMemberListEntry::getPlayerName);
                break;
            }
            case SORT_BY_RANK: {
                entries.forEach(entry -> entry.updateClanRank(this.client));
                comparator = Comparator.comparing(ClanMemberListEntry::getClanRank);
            }
        }
        entries.sort(this.config.reverseSort() ? comparator.reversed() : comparator);
        for (int i = 0; i < entries.size(); ++i) {
            ((ClanMemberListEntry)entries.get(i)).setOriginalYAndRevalidate(15 * i);
        }
    }

    private void initWidgets() {
        this.clanMemberListsWidget = this.client.getWidget(WidgetInfo.CLAN_MEMBER_LIST);
        this.clanMemberListHeaderWidget = this.client.getWidget(WidgetInfo.CLAN_MEMBER_LIST.getGroupId(), 0);
        if (this.clanMemberListHeaderWidget == null) {
            return;
        }
        this.clanMemberListHeaderWidget.deleteAllChildren();
        this.sortButton = this.clanMemberListHeaderWidget.createChild(-1, 5);
        this.reorderSortButton(this.config.activeSortType());
        this.sortButton.setOriginalY(2);
        this.sortButton.setOriginalX(2);
        this.sortButton.setOriginalHeight(16);
        this.sortButton.setOriginalWidth(16);
        this.sortButton.setOnClickListener(new Object[]{this::handleSortButtonClick});
        this.sortButton.setOnOpListener(new Object[]{this::handleSortButtonOp});
        this.sortButton.setHasListener(true);
        this.updateSortButtonSprite();
        this.sortButton.revalidate();
    }

    private void updateSortButtonSprite() {
        this.sortButton.setSpriteId(this.config.reverseSort() ? 773 : 788);
    }

    private void handleSortButtonClick(ScriptEvent event) {
        this.config.reverseSort(!this.config.reverseSort());
        this.updateSortButtonSprite();
    }

    private void handleSortButtonOp(ScriptEvent event) {
        for (SortType type : SortType.values()) {
            if (type.actionIndex != event.getOp()) continue;
            this.config.activeSortType(type);
            this.reorderSortButton(type);
            return;
        }
    }

    private void reorderSortButton(SortType firstType) {
        int index = 0;
        this.sortButton.setAction(index, firstType.name);
        firstType.actionIndex = 1;
        for (SortType type : SortType.values()) {
            if (type == firstType) continue;
            this.sortButton.setAction(++index, type.name);
            type.actionIndex = index + 1;
        }
    }
}

