/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit.clanmemberlistsort;

import eu.jodelahithit.clanmemberlistsort.Utils;
import java.util.Arrays;
import java.util.Random;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClanMemberListEntry {
    private static final Logger log = LoggerFactory.getLogger(ClanMemberListEntry.class);
    Widget opListener;
    Widget icon;
    Widget name;
    Widget world;
    ClanRank clanRank = this.randomRank();
    static int debugClanChannelPrintCount = 0;
    static int debugClanSettingsPrintCount = 0;
    static int debugClanMemberPrintCount = 0;

    public ClanMemberListEntry(Widget opListener, Widget name, Widget world, Widget icon) {
        this.opListener = opListener;
        this.name = name;
        this.world = world;
        this.icon = icon;
    }

    private ClanRank randomRank() {
        int pick = new Random().nextInt(ClanRank.values().length);
        return ClanRank.values()[pick];
    }

    public void setOriginalYAndRevalidate(int y) {
        if (this.opListener != null) {
            this.opListener.setOriginalY(y);
            this.opListener.revalidate();
        }
        this.name.setOriginalY(y);
        this.name.revalidate();
        this.world.setOriginalY(y);
        this.world.revalidate();
        this.icon.setOriginalY(y);
        this.icon.revalidate();
    }

    public void updateClanRank(Client client) {
        ClanChannel clanChannel = client.getClanChannel();
        if (clanChannel == null) {
            this.debugClanChannel();
            return;
        }
        ClanSettings clanSettings = client.getClanSettings();
        if (clanSettings == null) {
            this.debugClanSettings(clanChannel);
            return;
        }
        ClanChannelMember member = null;
        try {
            String cleanName = Utils.removeDecorationsFromString(this.name.getText());
            member = clanChannel.findMember(cleanName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (member == null) {
            this.debugClanMember(clanChannel, clanSettings);
            return;
        }
        this.clanRank = member.getRank();
    }

    public int getIconSpriteID() {
        return this.icon.getSpriteId();
    }

    public String getPlayerName() {
        return this.name.getText().toLowerCase();
    }

    public String getWorld() {
        return this.world.getText();
    }

    public ClanRank getClanRank() {
        return this.clanRank;
    }

    private void debugClanChannel() {
        if (debugClanChannelPrintCount++ > 5) {
            return;
        }
        log.error("Clan channel is null");
    }

    private void debugClanSettings(ClanChannel clanChannel) {
        if (debugClanSettingsPrintCount++ > 5) {
            return;
        }
        log.error("Clan settings is null for clan: {}", (Object)clanChannel.getName());
    }

    private void debugClanMember(ClanChannel clanChannel, ClanSettings clanSettings) {
        if (debugClanMemberPrintCount++ > 5) {
            return;
        }
        log.error("Clan member is null for clan: " + clanChannel.getName());
        StringBuilder clanMemberNames = new StringBuilder();
        for (ClanChannelMember member : clanChannel.getMembers()) {
            String memberName = member.getName();
            clanMemberNames.append(memberName).append(Arrays.toString(memberName.getBytes())).append("\n");
        }
        log.error("Player name: {}|{}\n{}", new Object[]{this.name.getText(), Arrays.toString(this.name.getText().getBytes()), clanMemberNames});
    }
}

