/*
 * Decompiled with CFR 0.152.
 */
package com.cannonhighlight;

import com.cannonhighlight.CannonHighlighterConfig;
import com.cannonhighlight.CannonHighlighterOverlay;
import com.google.inject.Provides;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Cannon Highlighter")
public class CannonHighlighterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CannonHighlighterPlugin.class);
    private NPC[] cachedNPCs = new NPC[0];
    private boolean cannonPlaced = false;
    private WorldPoint cannonPosition = null;
    @Inject
    private Client client;
    @Inject
    private CannonHighlighterConfig config;
    @Inject
    private CannonHighlighterOverlay npcOverlay;
    @Inject
    private OverlayManager overlayManager;
    ArrayList<LocalPoint> cannonDoubleHitSpots = new ArrayList();
    ArrayList<LocalPoint> cannonNeverHitSpots = new ArrayList();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.npcOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.npcOverlay);
        this.cannonPlaced = false;
        this.cannonPosition = null;
        this.cannonNeverHitSpots.clear();
        this.cannonDoubleHitSpots.clear();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.cachedNPCs = this.client.getCachedNPCs();
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        int placedObjectId = gameObject.getId();
        Player localPlayer = this.client.getLocalPlayer();
        if (!(placedObjectId != 7 && placedObjectId != 43029 || this.cannonPlaced || localPlayer.getWorldLocation().distanceTo(gameObject.getWorldLocation()) > 2 || localPlayer.getAnimation() != 827)) {
            this.cannonPosition = gameObject.getWorldLocation();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("You add the furnace.")) {
            this.cannonPlaced = true;
        }
        if (event.getMessage().contains("You pick up the cannon") || event.getMessage().contains("Your cannon has decayed. Speak to Nulodion to get a new one!")) {
            this.cannonPlaced = false;
            this.cannonPosition = null;
            this.cannonNeverHitSpots.clear();
            this.cannonDoubleHitSpots.clear();
        }
    }

    @Provides
    CannonHighlighterConfig provideConfig(ConfigManager configManager) {
        return (CannonHighlighterConfig)configManager.getConfig(CannonHighlighterConfig.class);
    }

    NPC[] getCachedNPCs() {
        return this.cachedNPCs;
    }

    boolean isCannonPlaced() {
        return this.cannonPlaced;
    }

    WorldPoint getCannonPosition() {
        return this.cannonPosition;
    }
}

