/*
 * Decompiled with CFR 0.152.
 */
package com.cannonhighlight;

import com.cannonhighlight.CannonHighlighterConfig;
import com.cannonhighlight.CannonHighlighterPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.TextComponent;

public class CannonHighlighterOverlay
extends Overlay {
    private static final NumberFormat TIME_LEFT_FORMATTER = DecimalFormat.getInstance(Locale.US);
    private static final int MAX_DISTANCE = 2500;
    private final Client client;
    private final CannonHighlighterConfig config;
    private final CannonHighlighterPlugin plugin;
    private final TextComponent textComponent = new TextComponent();

    @Inject
    CannonHighlighterOverlay(Client client, CannonHighlighterConfig config, CannonHighlighterPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getCannonPosition() == null || !this.plugin.isCannonPlaced()) {
            return null;
        }
        LocalPoint cannonPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.plugin.getCannonPosition());
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        if (cannonPoint == null || !this.plugin.isCannonPlaced()) {
            return null;
        }
        if (localLocation.distanceTo(cannonPoint) <= 2500) {
            this.drawDoubleHitSpots(graphics, cannonPoint);
        }
        for (NPC npc : this.plugin.getCachedNPCs()) {
            if (npc == null || npc.getCombatLevel() <= 0) continue;
            boolean marked = false;
            LocalPoint npcLocalPoint = npc.getLocalLocation();
            int size = npc.getTransformedComposition().getSize();
            int x = npcLocalPoint.getX() - (size - 1) * 128 / 2;
            int y = npcLocalPoint.getY() - (size - 1) * 128 / 2;
            for (LocalPoint doubleHitSpot : this.plugin.cannonDoubleHitSpots) {
                if (Math.abs(doubleHitSpot.getX() - x) >= 64 || Math.abs(doubleHitSpot.getY() - y) >= 64) continue;
                if (this.config.highlightHull() || this.config.highlightSouthWestTile() || this.config.drawNames()) {
                    this.renderNpcOverlay(graphics, npc, HittableType.DOUBLE);
                }
                marked = true;
                break;
            }
            if (!marked) {
                for (LocalPoint neverHitSpot : this.plugin.cannonNeverHitSpots) {
                    if (Math.abs(neverHitSpot.getX() - x) >= 64 || Math.abs(neverHitSpot.getY() - y) >= 64) continue;
                    if (this.config.highlightHull() || this.config.highlightSouthWestTile() || this.config.drawNames()) {
                        this.renderNpcOverlay(graphics, npc, HittableType.UNHITTABLE);
                    }
                    marked = true;
                    break;
                }
            }
            if (!this.config.highlightHull() && !this.config.highlightSouthWestTile() && !this.config.drawNames() || marked || Math.abs(cannonPoint.getX() - x) > 384 || Math.abs(cannonPoint.getY() - y) > 384) continue;
            this.renderNpcOverlay(graphics, npc, HittableType.SINGLE);
        }
        return null;
    }

    private void drawDoubleHitSpots(Graphics2D graphics, LocalPoint startTile) {
        this.plugin.cannonNeverHitSpots.add(new LocalPoint(startTile.getX(), startTile.getY()));
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                int yPos;
                int xPos;
                LocalPoint marker;
                Polygon poly;
                if (y != 1 && x != 1 && y != -1 && x != -1 || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)(marker = new LocalPoint(xPos = startTile.getX() - x * 128, yPos = startTile.getY() - y * 128)))) == null || Math.abs(y) == 1 && Math.abs(x) == 1) continue;
                if (Math.abs(y) <= 1 && x == 0 || Math.abs(x) <= 1 && y == 0) {
                    if (this.plugin.cannonNeverHitSpots.size() < 5) {
                        this.plugin.cannonNeverHitSpots.add(marker);
                    }
                    if (!this.config.showHitZones()) continue;
                    OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.config.unhittableColor());
                    continue;
                }
                if (this.config.showHitZones()) {
                    OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)this.config.doubleColor());
                }
                if (this.plugin.cannonDoubleHitSpots.size() >= 16) continue;
                this.plugin.cannonDoubleHitSpots.add(marker);
            }
        }
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC actor, HittableType hittableType) {
        Point textLocation;
        Color color = Color.yellow;
        String text = "";
        switch (hittableType) {
            case UNHITTABLE: {
                color = this.config.unhittableColor();
                text = "Unhittable";
                break;
            }
            case SINGLE: {
                color = this.config.singleColor();
                text = "Single";
                break;
            }
            case DOUBLE: {
                color = this.config.doubleColor();
                text = "Double";
            }
        }
        NPCComposition npcComposition = actor.getTransformedComposition();
        if (npcComposition == null || !npcComposition.isInteractible() || actor.isDead()) {
            return;
        }
        if (this.config.highlightHull()) {
            Shape objectClickbox = actor.getConvexHull();
            this.renderPoly(graphics, color, objectClickbox);
        }
        if (this.config.highlightSouthWestTile()) {
            int size = npcComposition.getSize();
            LocalPoint lp = actor.getLocalLocation();
            int x = lp.getX() - (size - 1) * 128 / 2;
            int y = lp.getY() - (size - 1) * 128 / 2;
            Polygon southWestTilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(x, y));
            this.renderPoly(graphics, color, southWestTilePoly);
        }
        if (this.config.drawNames() && (textLocation = actor.getCanvasTextLocation(graphics, text, actor.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)color);
        }
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape polygon) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(polygon);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(polygon);
        }
    }

    static {
        ((DecimalFormat)TIME_LEFT_FORMATTER).applyPattern("#0.0");
    }

    static enum HittableType {
        UNHITTABLE,
        SINGLE,
        DOUBLE;

    }
}

