/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.betterskilltooltips;

import com.google.inject.Provides;
import io.hydrox.betterskilltooltips.BetterSkillTooltipsConfig;
import io.hydrox.betterskilltooltips.SkillData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

@PluginDescriptor(name="Better Skill Tooltips", description="Enhance your vanilla skill tooltips!", tags={"skill", "tooltip", "virtual", "120", "goal", "xp"})
public class BetterSkillTooltipsPlugin
extends Plugin {
    private static final FontMetrics FONT_METRICS = Toolkit.getDefaultToolkit().getFontMetrics(FontManager.getRunescapeFont());
    private static final int SCRIPT_SKILL_TOOLTIP_CREATE = 2344;
    private static final int SKILL_TOOLTIP_CHILDID = 28;
    private static final int BAR_PADDING_X = 6;
    private static final int BAR_PADDING_Y = 5;
    private static final int BAR_HEIGHT = 15;
    private static final int LINE_HEIGHT = 12;
    private static final int WIDTH_PADDING = 4;
    private static final int HEIGHT_PADDING = 7;
    private static final NumberFormat DECIMAL_FORMATTER = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    @Inject
    private Client client;
    @Inject
    private BetterSkillTooltipsConfig config;

    @Provides
    BetterSkillTooltipsConfig provideConfig(ConfigManager configManager) {
        return (BetterSkillTooltipsConfig)configManager.getConfig(BetterSkillTooltipsConfig.class);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() != 2344) {
            return;
        }
        Widget tooltip = this.client.getWidget(320, 28);
        if (tooltip == null || tooltip.isHidden()) {
            return;
        }
        SkillData currentSkill = this.getSkill(tooltip);
        if (currentSkill != null) {
            this.enhanceTooltip(tooltip, currentSkill);
        }
    }

    private SkillData getSkill(Widget tooltip) {
        Widget leftText = tooltip.getChild(2);
        if (leftText == null) {
            return null;
        }
        String text = leftText.getText();
        text = text.substring(0, text.indexOf(" "));
        return SkillData.fromName(text);
    }

    private void enhanceTooltip(Widget tooltip, SkillData skillData) {
        int skillExperience = this.client.getSkillExperience(skillData.getSkill());
        if (skillData == SkillData.OVERALL ? skillExperience == 200000000 * SkillData.count() : skillExperience == 200000000) {
            return;
        }
        int lines = this.getLinesInTooltip(tooltip.getHeight());
        int bonusHeight = 0;
        Widget background = tooltip.getChild(0);
        Widget border = tooltip.getChild(1);
        Widget leftText = tooltip.getChild(2);
        Widget rightText = tooltip.getChild(3);
        if (lines == 1 && this.config.virtualLevels() && skillData != SkillData.OVERALL) {
            int skillLevel = Experience.getLevelForXp((int)skillExperience);
            int nextExperience = skillLevel == 126 ? 200000000 : Experience.getXpForLevel((int)(skillLevel + 1));
            lines += 3;
            leftText.setText(leftText.getText() + "<br>Virtual level:<br>Next level at:<br>Remaining XP:");
            rightText.setText(rightText.getText() + "<br>" + skillLevel + "<br>" + QuantityFormatter.formatNumber((long)nextExperience) + "<br>" + QuantityFormatter.formatNumber((long)(nextExperience - skillExperience)));
        }
        long goalStartXP = this.client.getVarpValue(skillData.getGoalStartVarp());
        long goalEndXP = this.client.getVarpValue(skillData.getGoalEndVarp());
        if (skillData == SkillData.OVERALL) {
            goalStartXP *= 1000L;
            goalEndXP *= 1000L;
        }
        boolean hasGoal = goalEndXP != 0L;
        Widget barLeft = null;
        Widget barRight = null;
        Widget barText = null;
        if (hasGoal && (this.config.goalInfo() || this.config.goalBar())) {
            if (this.config.goalInfo()) {
                lines += 2;
                leftText.setText(leftText.getText() + "<br>Goal XP:<br>Until goal:");
                rightText.setText(rightText.getText() + "<br>" + QuantityFormatter.formatNumber((long)goalEndXP) + "<br>" + QuantityFormatter.formatNumber((long)(goalEndXP - (long)skillExperience)));
            }
            if (this.config.goalBar()) {
                double percentage = Math.min(1.0, (double)((long)skillExperience - goalStartXP) / (double)(goalEndXP - goalStartXP));
                barRight = tooltip.createChild(-1, 3);
                barRight.setOriginalX(6);
                barRight.setOriginalY(5);
                barRight.setWidthMode(1);
                barRight.setYPositionMode(2);
                barRight.setOriginalWidth(12);
                barRight.setOriginalHeight(15);
                barRight.setTextColor(Color.RED.getRGB());
                barRight.setFilled(true);
                barLeft = tooltip.createChild(-1, 3);
                barLeft.setOriginalX(6);
                barLeft.setOriginalY(5);
                barLeft.setYPositionMode(2);
                barLeft.setOriginalWidth((int)((double)(tooltip.getOriginalWidth() - barRight.getOriginalWidth()) * percentage));
                barLeft.setOriginalHeight(15);
                barLeft.setTextColor(Color.GREEN.darker().getRGB());
                barLeft.setFilled(true);
                barText = tooltip.createChild(-1, 4);
                barText.setOriginalX(6);
                barText.setOriginalY(6);
                barText.setOriginalWidth(12);
                barText.setOriginalHeight(15);
                barText.setWidthMode(1);
                barText.setYPositionMode(2);
                barText.setXTextAlignment(1);
                barText.setYTextAlignment(2);
                barText.setFontId(494);
                barText.setText(DECIMAL_FORMATTER.format(percentage * 100.0) + "%");
                barText.setTextColor(Color.WHITE.getRGB());
                barText.setTextShadowed(true);
                bonusHeight += 20;
            }
        }
        int width = this.calculateTooltipWidth(leftText.getText(), rightText.getText());
        int height = this.calculateTooltipTextHeight(lines) + bonusHeight;
        tooltip.setOriginalWidth(width);
        tooltip.setOriginalHeight(height);
        tooltip.revalidate();
        background.revalidate();
        border.revalidate();
        leftText.revalidate();
        rightText.revalidate();
        if (hasGoal && this.config.goalBar()) {
            barLeft.revalidate();
            barRight.revalidate();
            barText.revalidate();
        }
        Widget skillTile = this.client.getWidget(320, skillData.getChildID());
        Widget skillsContainer = tooltip.getParent();
        int x = skillTile.getOriginalX();
        int y = skillTile.getOriginalY();
        int h = skillTile.getOriginalHeight();
        x += 5;
        int y2 = y + h + 5;
        x = Math.min(x, skillsContainer.getOriginalWidth() - width);
        if (y2 > skillsContainer.getHeight() - height) {
            y2 = y - height - 5;
        }
        tooltip.setOriginalX(x);
        tooltip.setOriginalY(y2);
        tooltip.revalidate();
    }

    private int calculateTooltipWidth(String leftText, String rightText) {
        String[] leftLines = leftText.split("<br>");
        String[] rightLines = rightText.split("<br>");
        int maxWidth = 0;
        for (int i = 0; i < Math.max(leftLines.length, rightLines.length); ++i) {
            int width;
            String left = "";
            String right = "";
            if (i < leftLines.length) {
                left = leftLines[i];
            }
            if (i < rightLines.length) {
                right = rightLines[i];
            }
            if ((width = FONT_METRICS.stringWidth(left) + FONT_METRICS.stringWidth(right) + 4) <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth + 4;
    }

    private int calculateTooltipTextHeight(int lines) {
        return lines * 12 + 7;
    }

    private int getLinesInTooltip(int height) {
        return (height - 7) / 12;
    }
}

