/*
 * Decompiled with CFR 0.152.
 */
package com.dryness;

import com.dryness.DryCalculatorPanel;
import com.dryness.DrynessInput;
import com.dryness.DrynessResult;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.runelite.client.util.ImageUtil;

public class DryCalculatorService {
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final Image SKELETON = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"skeleton.png");
    private static final Image DOG = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"dog.png");
    private static final Image FUCK = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"fuck.png");
    private static final Image CRY = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"cry.png");
    private static final Image NOTHING = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"nothing.png");
    private static final Image OPRAH = ImageUtil.loadImageResource(DryCalculatorPanel.class, (String)"oprah.png");

    public static DrynessResult calculateDryness(DrynessInput input) {
        if (input.getAmountOfDrops() == 0) {
            BigDecimal dryness = DryCalculatorService.toPercentage(BigDecimal.ONE.subtract(input.getChance()).pow(input.getKc()));
            return new DrynessResult(String.format("With %s kc you had a\n%s%% chance of no drops\n%s%% chance of at least 1\nU rn", input.getKc(), dryness, ONE_HUNDRED.subtract(dryness)), DryCalculatorService.getDrynessImage(dryness.doubleValue(), input.getAmountOfDrops()));
        }
        int choose = DryCalculatorService.choose(input.getKc(), input.getAmountOfDrops());
        BigDecimal dryness = BigDecimal.valueOf(choose).multiply(input.getChance().pow(input.getAmountOfDrops()).multiply(BigDecimal.ONE.subtract(input.getChance()).pow(input.getKc() - input.getAmountOfDrops())));
        BigDecimal dryness2 = BigDecimal.ZERO;
        for (int i = 0; i <= input.getAmountOfDrops(); ++i) {
            dryness2 = dryness2.add(BigDecimal.valueOf(DryCalculatorService.choose(input.getKc(), i)).multiply(input.getChance().pow(i)).multiply(BigDecimal.ONE.subtract(input.getChance()).pow(input.getKc() - i)));
        }
        BigDecimal dryness3 = DryCalculatorService.toPercentage(BigDecimal.ONE.subtract(dryness2).add(dryness));
        dryness2 = DryCalculatorService.toPercentage(dryness2);
        dryness = DryCalculatorService.toPercentage(dryness);
        Image drynessImage = input.getAmountOfDrops() >= 1 ? DryCalculatorService.getDrynessImage(dryness2.doubleValue(), input.getAmountOfDrops()) : DryCalculatorService.getDrynessImage(dryness.doubleValue(), input.getAmountOfDrops());
        return new DrynessResult(String.format("With %s kc you had a\n%s%% chance for exactly %s\n%s%% chance for %s or fewer\n%s%% chance for %s or more\nU rn", input.getKc(), dryness, input.getAmountOfDrops(), dryness2, input.getAmountOfDrops(), dryness3, input.getAmountOfDrops()), drynessImage);
    }

    private static Image getDrynessImage(double dryness, int drops) {
        if (drops == 0 && dryness > 50.0) {
            return NOTHING;
        }
        if (dryness <= 5.0) {
            return SKELETON;
        }
        if (dryness <= 10.0) {
            return DOG;
        }
        if (dryness <= 25.0) {
            return FUCK;
        }
        if (dryness <= 50.0) {
            return CRY;
        }
        if (dryness <= 75.0) {
            return NOTHING;
        }
        return OPRAH;
    }

    private static BigDecimal toPercentage(BigDecimal input) {
        return input.multiply(ONE_HUNDRED).setScale(4, RoundingMode.HALF_UP);
    }

    private static int choose(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (k == 0 || k == n) {
            return 1;
        }
        k = Math.min(k, n - k);
        int c = 1;
        for (int i = 0; i <= k - 1; ++i) {
            c = c * (n - i) / (i + 1);
        }
        return c;
    }
}

