/*
 * Decompiled with CFR 0.152.
 */
package com.dryness;

import com.dryness.DryCalculatorService;
import com.dryness.DrynessInput;
import com.dryness.DrynessResult;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

public class DryCalculatorPanel
extends PluginPanel {
    private final JTextField droprate = new JTextField();
    private final JTextField drops = new JTextField();
    private final JTextField kc = new JTextField();
    private final JTextArea result = new JTextArea();
    private final ImageIcon resultIcon = new ImageIcon();

    DryCalculatorPanel() {
        this.result.setLineWrap(true);
        this.result.setEditable(false);
        JButton calculate = new JButton();
        calculate.setText("Calculate");
        calculate.addActionListener(this::handleClick);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel dryPanel = new JPanel();
        dryPanel.setLayout(new GridLayout(0, 1));
        JLabel title = new JLabel();
        title.setFont(FontManager.getDefaultBoldFont());
        title.setText("Dryness calculator");
        JLabel dropRateLabel = new JLabel();
        dropRateLabel.setText("Droprate");
        JLabel kcLabel = new JLabel();
        kcLabel.setText("Kc");
        JLabel dropsLabel = new JLabel();
        dropsLabel.setText("Amount of drops");
        dryPanel.add(title);
        dryPanel.add(dropRateLabel);
        dryPanel.add(this.droprate);
        dryPanel.add(kcLabel);
        dryPanel.add(this.kc);
        dryPanel.add(dropsLabel);
        dryPanel.add(this.drops);
        dryPanel.add(calculate);
        this.add(dryPanel, "North");
        this.add(this.result, "Center");
        JLabel resultImage = new JLabel(this.resultIcon);
        this.add(resultImage, "South");
    }

    private void handleClick(ActionEvent actionEvent) {
        DrynessInput input = null;
        try {
            input = new DrynessInput(this.droprate.getText(), this.kc.getText(), this.drops.getText());
        }
        catch (Exception exception) {
            this.result.setText("Invalid input: " + exception.getMessage());
            this.resultIcon.setImage(null);
        }
        if (input != null) {
            DrynessResult drynessResult = DryCalculatorService.calculateDryness(input);
            this.result.setText(drynessResult.getText());
            this.resultIcon.setImage(drynessResult.getImage());
        }
    }
}

