/*
 * Decompiled with CFR 0.152.
 */
package dekvall.notempty;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Not Empty", description="Never empty potions again!")
public class NotEmptyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NotEmptyPlugin.class);
    private static final String DRINK_PATTERN = ".*\\(\\d\\)";
    @Inject
    private Client client;

    protected void startUp() throws Exception {
        log.info("Not Empty started!");
    }

    protected void shutDown() throws Exception {
        log.info("Not Empty stopped!");
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        int groupId = WidgetInfo.TO_GROUP((int)event.getActionParam1());
        if (149 != groupId) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        ArrayList<MenuEntry> cleaned = new ArrayList<MenuEntry>();
        for (MenuEntry entry : menuEntries) {
            String option = entry.getOption().toLowerCase();
            String target = Text.removeTags((String)entry.getTarget());
            if (entry.getType() == MenuAction.CC_OP_LOW_PRIORITY && "empty".equals(option) && Pattern.matches(DRINK_PATTERN, target)) continue;
            cleaned.add(entry);
        }
        this.client.setMenuEntries(cleaned.toArray(new MenuEntry[0]));
    }
}

