/*
 * Decompiled with CFR 0.152.
 */
package com.sextantlocator.ui;

import com.sextantlocator.SextantLocatorConfig;
import com.sextantlocator.SextantPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class CoordinatesTooltipOverlay
extends Overlay {
    private final Client client;
    private final SextantLocatorConfig sextantLocatorConfig;
    private final TooltipManager tooltipManager;

    @Inject
    public CoordinatesTooltipOverlay(Client client, SextantLocatorConfig sextantLocatorConfig, TooltipManager tooltipManager) {
        this.client = client;
        this.sextantLocatorConfig = sextantLocatorConfig;
        this.tooltipManager = tooltipManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.sextantLocatorConfig.displayTileCoordinatesOverlay()) {
            return null;
        }
        this.addTooltip();
        this.renderSelectedTile(graphics);
        return null;
    }

    private void addTooltip() {
        Tile selectedTile = this.client.getSelectedSceneTile();
        if (selectedTile == null || selectedTile.getWorldLocation() == null) {
            return;
        }
        int selectedTileX = selectedTile.getWorldLocation().getX();
        int selectedTileY = selectedTile.getWorldLocation().getY();
        SextantPoint selectedTileSextantCoordinates = new SextantPoint(selectedTileX, selectedTileY);
        this.tooltipManager.add(new Tooltip(selectedTileSextantCoordinates.toString()));
    }

    private void renderSelectedTile(Graphics2D graphics) {
        Tile selectedTile = this.client.getSelectedSceneTile();
        if (selectedTile == null || selectedTile.getLocalLocation() == null) {
            return;
        }
        Polygon selectedTilePolygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)selectedTile.getLocalLocation());
        if (selectedTilePolygon == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)selectedTilePolygon, (Color)this.sextantLocatorConfig.selectedTileBorderColor(), (Color)this.sextantLocatorConfig.selectedTileFillColor(), (Stroke)new BasicStroke(this.sextantLocatorConfig.selectedTileBorderWidth()));
    }
}

