/*
 * Decompiled with CFR 0.152.
 */
package com.sextantlocator;

import com.google.inject.Provides;
import com.sextantlocator.SextantLocatorConfig;
import com.sextantlocator.ui.CoordinatesMapOverlay;
import com.sextantlocator.ui.CoordinatesOverlay;
import com.sextantlocator.ui.CoordinatesTooltipOverlay;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Sextant Locator", description="Sextant's coordinates helper.", tags={"sextant", "coordinates", "world", "location", "locator", "clues"})
public class SextantLocatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SextantLocatorPlugin.class);
    @Inject
    private SextantLocatorConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    CoordinatesOverlay coordinatesOverlay;
    @Inject
    CoordinatesTooltipOverlay coordinatesTooltipOverlay;
    @Inject
    CoordinatesMapOverlay coordinatesMapOverlay;

    @Provides
    SextantLocatorConfig provideConfig(ConfigManager configManager) {
        return (SextantLocatorConfig)configManager.getConfig(SextantLocatorConfig.class);
    }

    protected void startUp() {
        this.addOverlays();
    }

    protected void shutDown() {
        this.removeOverlays();
    }

    private void addOverlays() {
        this.overlayManager.add((Overlay)this.coordinatesOverlay);
        this.overlayManager.add((Overlay)this.coordinatesTooltipOverlay);
        this.overlayManager.add((Overlay)this.coordinatesMapOverlay);
    }

    private void removeOverlays() {
        this.overlayManager.remove((Overlay)this.coordinatesOverlay);
        this.overlayManager.remove((Overlay)this.coordinatesTooltipOverlay);
        this.overlayManager.remove((Overlay)this.coordinatesMapOverlay);
    }
}

