/*
 * Decompiled with CFR 0.152.
 */
package com.sextantlocator;

import com.sextantlocator.SextantAxis;
import net.runelite.api.coords.Direction;

public class SextantCoordinate {
    private final float minutes;
    private final SextantAxis axis;
    private final float OBSERVATORY_X = 2440.0f;
    private final float OBSERVATORY_Y = 3161.0f;
    private final float MINUTES_PER_TILE = 1.875f;

    public SextantCoordinate(float degrees, float minutes, Direction direction) {
        this.axis = direction == Direction.NORTH || direction == Direction.SOUTH ? SextantAxis.VERTICAL : SextantAxis.HORIZONTAL;
        this.minutes = degrees * 60.0f + minutes;
    }

    public SextantCoordinate(float worldCoordinate, SextantAxis axis) {
        this.axis = axis;
        this.minutes = this.worldCoordinateToMinutes(worldCoordinate, axis);
    }

    public int getDegrees() {
        return (int)Math.abs(this.minutes / 60.0f);
    }

    public float getMinutes() {
        return Math.abs(this.minutes % 60.0f);
    }

    public int getMinutesInteger() {
        return (int)Math.abs(this.minutes % 60.0f);
    }

    public Direction getDirection() {
        if (this.minutes >= 0.0f) {
            if (this.axis == SextantAxis.HORIZONTAL) {
                return Direction.EAST;
            }
            return Direction.NORTH;
        }
        if (this.axis == SextantAxis.HORIZONTAL) {
            return Direction.WEST;
        }
        return Direction.SOUTH;
    }

    private float worldCoordinateToMinutes(float worldCoordinate, SextantAxis axis) {
        worldCoordinate = axis == SextantAxis.HORIZONTAL ? (worldCoordinate -= 2440.0f) : (worldCoordinate -= 3161.0f);
        return worldCoordinate * 1.875f;
    }

    public String toString() {
        return this.getDegrees() + " deg. " + this.getMinutesInteger() + " min. " + this.getDirection().toString().charAt(0);
    }
}

