/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetupsPlugin;
import inventorysetups.ui.InventorySetupsPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.LinkBrowser;

public class InventorySetupsUpdateNewsPanel
extends JPanel {
    InventorySetupsUpdateNewsPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel) {
        JLabel welcomeText = new JLabel("Inventory Setups " + plugin.getCurrentVersionString());
        welcomeText.setFont(FontManager.getRunescapeBoldFont());
        welcomeText.setHorizontalAlignment(0);
        JPanel welcomePanel = new JPanel(new BorderLayout());
        welcomePanel.add((Component)welcomeText, "North");
        JPanel latestUpdatePanelInfo = this.getLatestUpdateInfoPanel();
        JLabel newUser = new JLabel("Are you a new user?");
        JLabel newUser2 = new JLabel("For help and support, click here");
        JButton linkToHelp = new JButton("View Guide");
        linkToHelp.addActionListener(e -> LinkBrowser.browse((String)"https://github.com/dillydill123/inventory-setups#inventory-setups"));
        newUser.setFont(FontManager.getRunescapeSmallFont());
        newUser2.setFont(FontManager.getRunescapeSmallFont());
        newUser.setHorizontalAlignment(0);
        newUser2.setHorizontalAlignment(0);
        JPanel newUserPanelInfo = new JPanel();
        newUserPanelInfo.setLayout(new BorderLayout());
        newUserPanelInfo.add((Component)newUser, "North");
        newUserPanelInfo.add((Component)newUser2, "Center");
        newUserPanelInfo.add((Component)linkToHelp, "South");
        JLabel suggestions = new JLabel("Have a suggestion? Found a bug?");
        JLabel suggestions2 = new JLabel("Click here to create an issue");
        JButton linkToSuggestion = new JButton("Make a Suggestion");
        linkToSuggestion.addActionListener(e -> LinkBrowser.browse((String)"https://github.com/dillydill123/inventory-setups/issues"));
        suggestions.setFont(FontManager.getRunescapeSmallFont());
        suggestions2.setFont(FontManager.getRunescapeSmallFont());
        suggestions.setHorizontalAlignment(0);
        suggestions2.setHorizontalAlignment(0);
        JPanel suggestionPanelInfo = new JPanel();
        suggestionPanelInfo.setLayout(new BorderLayout());
        suggestionPanelInfo.add((Component)suggestions, "North");
        suggestionPanelInfo.add((Component)suggestions2, "Center");
        suggestionPanelInfo.add((Component)linkToSuggestion, "South");
        JPanel closePanel = new JPanel(new BorderLayout());
        JButton returnToSetups = new JButton("Return to Setups");
        returnToSetups.addActionListener(e -> {
            plugin.setSavedVersionString(plugin.getCurrentVersionString());
            panel.redrawOverviewPanel(true);
        });
        JLabel clickButtonToLeave = new JLabel("Click here to hide this window");
        JLabel clickButtonToLeave2 = new JLabel("until the next update");
        clickButtonToLeave.setFont(FontManager.getRunescapeSmallFont());
        clickButtonToLeave2.setFont(FontManager.getRunescapeSmallFont());
        clickButtonToLeave.setHorizontalAlignment(0);
        clickButtonToLeave2.setHorizontalAlignment(0);
        closePanel.add((Component)clickButtonToLeave, "North");
        closePanel.add((Component)clickButtonToLeave2, "Center");
        closePanel.add((Component)returnToSetups, "South");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(welcomePanel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        contentPanel.add(latestUpdatePanelInfo);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        contentPanel.add(closePanel);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        contentPanel.add(newUserPanelInfo);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        contentPanel.add(suggestionPanelInfo);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)contentPanel, "Center");
    }

    private JPanel getLatestUpdateInfoPanel() {
        JLabel patchNotesLabel = new JLabel("Patch Notes");
        patchNotesLabel.setFont(FontManager.getRunescapeSmallFont());
        patchNotesLabel.setHorizontalAlignment(0);
        JPanel patchTitlePanel = new JPanel(new BorderLayout());
        patchTitlePanel.add((Component)patchNotesLabel, "North");
        String updateText = "Sections and their respective setups will now correctly match the order of the side panel in the Show Worn Items right click menu.\n\nAdded a hotkey for toggling section mode.\n\nFixed granite cannonball -> cannonball variation mapping.\n\nAdded an option to replace an item in all setups with a new item. Shift + Right click an inventory or equipment slot on the side panel to access this option. Keep in mind this will replace ALL occurrences of the old item in ALL setups with the new item.";
        JTextArea textArea = new JTextArea(2, 20);
        textArea.setText(updateText);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setBackground(ColorScheme.DARK_GRAY_COLOR);
        Font textAreaFont = FontManager.getRunescapeSmallFont();
        textAreaFont = textAreaFont.deriveFont(textAreaFont.getStyle(), (float)textAreaFont.getSize() - 0.1f);
        textArea.setFont(textAreaFont);
        textArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add((Component)patchTitlePanel, "North");
        contentPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        contentPanel.add(this.getJSeparator(ColorScheme.LIGHT_GRAY_COLOR));
        contentPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        contentPanel.add(textArea);
        contentPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        contentPanel.add(this.getJSeparator(ColorScheme.LIGHT_GRAY_COLOR));
        JPanel updatePanel = new JPanel(new BorderLayout());
        updatePanel.add((Component)contentPanel, "Center");
        return updatePanel;
    }

    private JSeparator getJSeparator(Color color) {
        JSeparator sep = new JSeparator();
        sep.setBackground(color);
        sep.setForeground(color);
        return sep;
    }
}

