/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSection;
import inventorysetups.InventorySetupsValidName;
import inventorysetups.ui.InventorySetupsNameActions;
import inventorysetups.ui.InventorySetupsPanel;
import inventorysetups.ui.InventorySetupsPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class InventorySetupsStandardPanel
extends InventorySetupsPanel
implements InventorySetupsValidName {
    private static final int H_GAP_BTN = 4;
    private static final ImageIcon BANK_FILTER_ICON;
    private static final ImageIcon BANK_FILTER_HOVER_ICON;
    private static final ImageIcon NO_BANK_FILTER_ICON;
    private static final ImageIcon NO_BANK_FILTER_HOVER_ICON;
    private static final ImageIcon HIGHLIGHT_COLOR_ICON;
    private static final ImageIcon HIGHLIGHT_COLOR_HOVER_ICON;
    private static final ImageIcon NO_HIGHLIGHT_COLOR_ICON;
    private static final ImageIcon NO_HIGHLIGHT_COLOR_HOVER_ICON;
    private static final ImageIcon TOGGLE_HIGHLIGHT_ICON;
    private static final ImageIcon TOGGLE_HIGHLIGHT_HOVER_ICON;
    private static final ImageIcon NO_TOGGLE_HIGHLIGHT_ICON;
    private static final ImageIcon NO_TOGGLE_HIGHLIGHT_HOVER_ICON;
    private static final ImageIcon UNORDERED_HIGHLIGHT_ICON;
    private static final ImageIcon UNORDERED_HIGHLIGHT_HOVER_ICON;
    private static final ImageIcon NO_UNORDERED_HIGHLIGHT_ICON;
    private static final ImageIcon NO_UNORDERED_HIGHLIGHT_HOVER_ICON;
    private static final ImageIcon FAVORITE_ICON;
    private static final ImageIcon FAVORITE_HOVER_ICON;
    private static final ImageIcon NO_FAVORITE_ICON;
    private static final ImageIcon NO_FAVORITE_HOVER_ICON;
    private static final ImageIcon VIEW_SETUP_ICON;
    private static final ImageIcon VIEW_SETUP_HOVER_ICON;
    private static final ImageIcon DELETE_ICON;
    private static final ImageIcon DELETE_HOVER_ICON;
    private static final ImageIcon EXPORT_ICON;
    private static final ImageIcon EXPORT_HOVER_ICON;
    public static final ImageIcon DISPLAY_COLOR_ICON;
    public static final ImageIcon DISPLAY_COLOR_HOVER_ICON;
    private final JLabel bankFilterIndicator = new JLabel();
    private final JLabel highlightColorIndicator = new JLabel();
    private final JLabel unorderedHighlightIndicator = new JLabel();
    private final JLabel favoriteIndicator = new JLabel();
    private final JLabel highlightIndicator = new JLabel();
    private final JLabel viewSetupLabel = new JLabel();
    private final JLabel exportLabel = new JLabel();
    private final JLabel deleteLabel = new JLabel();

    InventorySetupsStandardPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, InventorySetup invSetup, InventorySetupsSection section) {
        this(plugin, panel, invSetup, section, true);
    }

    InventorySetupsStandardPanel(final InventorySetupsPlugin plugin, final InventorySetupsPluginPanel panel, final InventorySetup invSetup, InventorySetupsSection section, boolean allowEditable) {
        super(plugin, panel, invSetup, section, allowEditable);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        InventorySetupsNameActions<InventorySetup> nameActions = new InventorySetupsNameActions<InventorySetup>(invSetup, plugin, panel, this, this.popupMenu, 50, ColorScheme.DARKER_GRAY_COLOR, true, null);
        JPanel bottomContainer = new JPanel(new BorderLayout());
        bottomContainer.setBorder(new EmptyBorder(8, 0, 8, 0));
        bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.bankFilterIndicator.setToolTipText("Enable bank filtering");
        this.bankFilterIndicator.setIcon(this.inventorySetup.isFilterBank() ? BANK_FILTER_ICON : NO_BANK_FILTER_ICON);
        this.bankFilterIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InventorySetupsStandardPanel.this.inventorySetup.setFilterBank(!InventorySetupsStandardPanel.this.inventorySetup.isFilterBank());
                    InventorySetupsStandardPanel.this.bankFilterIndicator.setToolTipText(InventorySetupsStandardPanel.this.inventorySetup.isFilterBank() ? "Disable bank filtering" : "Enable bank filtering");
                    InventorySetupsStandardPanel.this.updateBankFilterLabel();
                    plugin.getDataManager().updateConfig(true, false);
                    panel.redrawOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsStandardPanel.this.bankFilterIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isFilterBank() ? BANK_FILTER_HOVER_ICON : NO_BANK_FILTER_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsStandardPanel.this.bankFilterIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isFilterBank() ? BANK_FILTER_ICON : NO_BANK_FILTER_ICON);
            }
        });
        this.unorderedHighlightIndicator.setToolTipText("Only highlight items that are missing from the inventory and ignore order");
        this.unorderedHighlightIndicator.setIcon(this.inventorySetup.isUnorderedHighlight() ? UNORDERED_HIGHLIGHT_ICON : NO_UNORDERED_HIGHLIGHT_ICON);
        this.unorderedHighlightIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InventorySetupsStandardPanel.this.inventorySetup.setUnorderedHighlight(!InventorySetupsStandardPanel.this.inventorySetup.isUnorderedHighlight());
                    InventorySetupsStandardPanel.this.unorderedHighlightIndicator.setToolTipText(InventorySetupsStandardPanel.this.inventorySetup.isUnorderedHighlight() ? "Enable default ordered highlighting" : "Only highlight items that are missing from the inventory and ignore order");
                    InventorySetupsStandardPanel.this.updateUnorderedHighlightIndicator();
                    plugin.getDataManager().updateConfig(true, false);
                    panel.redrawOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsStandardPanel.this.unorderedHighlightIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isUnorderedHighlight() ? UNORDERED_HIGHLIGHT_HOVER_ICON : NO_UNORDERED_HIGHLIGHT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsStandardPanel.this.unorderedHighlightIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isUnorderedHighlight() ? UNORDERED_HIGHLIGHT_ICON : NO_UNORDERED_HIGHLIGHT_ICON);
            }
        });
        this.favoriteIndicator.setToolTipText(this.inventorySetup.isFavorite() ? "Remove this setup from the list of favorites" : "Favorite this setup so it appears at the top of the list");
        this.favoriteIndicator.setIcon(this.inventorySetup.isFavorite() ? FAVORITE_ICON : NO_FAVORITE_ICON);
        this.favoriteIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InventorySetupsStandardPanel.this.inventorySetup.setFavorite(!InventorySetupsStandardPanel.this.inventorySetup.isFavorite());
                    InventorySetupsStandardPanel.this.favoriteIndicator.setToolTipText(InventorySetupsStandardPanel.this.inventorySetup.isFavorite() ? "Remove this setup from the list of favorites" : "Favorite this setup so it appears at the top of the list");
                    InventorySetupsStandardPanel.this.updateFavoriteIndicator();
                    plugin.getDataManager().updateConfig(true, false);
                    panel.redrawOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsStandardPanel.this.favoriteIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isFavorite() ? FAVORITE_HOVER_ICON : NO_FAVORITE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsStandardPanel.this.favoriteIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isFavorite() ? FAVORITE_ICON : NO_FAVORITE_ICON);
            }
        });
        this.highlightIndicator.setToolTipText("Enable highlighting");
        this.highlightIndicator.setIcon(this.inventorySetup.isHighlightDifference() ? TOGGLE_HIGHLIGHT_ICON : NO_TOGGLE_HIGHLIGHT_ICON);
        this.highlightIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    InventorySetupsStandardPanel.this.inventorySetup.setHighlightDifference(!InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference());
                    InventorySetupsStandardPanel.this.highlightIndicator.setToolTipText(InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference() ? "Disable highlighting" : "Enable highlighting");
                    InventorySetupsStandardPanel.this.updateToggleHighlightLabel();
                    InventorySetupsStandardPanel.this.updateHighlightColorLabel();
                    plugin.getDataManager().updateConfig(true, false);
                    panel.redrawOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.highlightIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference() ? TOGGLE_HIGHLIGHT_HOVER_ICON : NO_TOGGLE_HIGHLIGHT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.highlightIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference() ? TOGGLE_HIGHLIGHT_ICON : NO_TOGGLE_HIGHLIGHT_ICON);
            }
        });
        this.highlightColorIndicator.setToolTipText("Edit highlight color");
        this.highlightColorIndicator.setIcon(this.inventorySetup.isHighlightDifference() ? HIGHLIGHT_COLOR_ICON : NO_HIGHLIGHT_COLOR_ICON);
        this.highlightColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    plugin.openColorPicker("Choose a Highlight color", invSetup.getHighlightColor(), c -> {
                        InventorySetupsStandardPanel.this.inventorySetup.setHighlightColor((Color)c);
                        InventorySetupsStandardPanel.this.updateHighlightColorLabel();
                        panel.redrawOverviewPanel(false);
                    });
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.highlightColorIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference() ? HIGHLIGHT_COLOR_HOVER_ICON : NO_HIGHLIGHT_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.highlightColorIndicator.setIcon(InventorySetupsStandardPanel.this.inventorySetup.isHighlightDifference() ? HIGHLIGHT_COLOR_ICON : NO_HIGHLIGHT_COLOR_ICON);
            }
        });
        JPanel leftActions = new JPanel(new FlowLayout(0, 4, 0));
        leftActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        leftActions.add(this.bankFilterIndicator);
        leftActions.add(this.unorderedHighlightIndicator);
        leftActions.add(this.highlightIndicator);
        leftActions.add(this.highlightColorIndicator);
        leftActions.add(this.favoriteIndicator);
        this.viewSetupLabel.setToolTipText("View setup");
        this.viewSetupLabel.setIcon(VIEW_SETUP_ICON);
        this.viewSetupLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    panel.setCurrentInventorySetup(InventorySetupsStandardPanel.this.inventorySetup, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.viewSetupLabel.setIcon(VIEW_SETUP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.viewSetupLabel.setIcon(VIEW_SETUP_ICON);
            }
        });
        this.exportLabel.setToolTipText("Export setup");
        this.exportLabel.setIcon(EXPORT_ICON);
        this.exportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    plugin.exportSetup(InventorySetupsStandardPanel.this.inventorySetup);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.exportLabel.setIcon(EXPORT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.exportLabel.setIcon(EXPORT_ICON);
            }
        });
        this.deleteLabel.setToolTipText("Delete setup");
        this.deleteLabel.setIcon(DELETE_ICON);
        this.deleteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    plugin.removeInventorySetup(InventorySetupsStandardPanel.this.inventorySetup);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.deleteLabel.setIcon(DELETE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsStandardPanel.this.deleteLabel.setIcon(DELETE_ICON);
            }
        });
        JPanel rightActions = new JPanel(new FlowLayout(2, 4, 0));
        rightActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        rightActions.add(this.viewSetupLabel);
        rightActions.add(this.exportLabel);
        rightActions.add(this.deleteLabel);
        bottomContainer.add((Component)leftActions, "West");
        bottomContainer.add((Component)rightActions, "East");
        this.add(nameActions, "North");
        this.add((Component)bottomContainer, "Center");
        this.updateHighlightColorLabel();
        this.updateToggleHighlightLabel();
        this.updateFavoriteIndicator();
    }

    @Override
    public boolean isNameValid(String name) {
        return !name.isEmpty() && !this.plugin.getCache().getInventorySetupNames().containsKey(name) && !this.inventorySetup.getName().equals(name);
    }

    @Override
    public void updateName(String newName) {
        this.plugin.updateSetupName(this.inventorySetup, newName);
    }

    private void updateHighlightColorLabel() {
        Color color = this.inventorySetup.getHighlightColor();
        this.highlightColorIndicator.setBorder(new MatteBorder(0, 0, 3, 0, color));
        this.highlightColorIndicator.setIcon(this.inventorySetup.isHighlightDifference() ? HIGHLIGHT_COLOR_ICON : NO_HIGHLIGHT_COLOR_ICON);
    }

    private void updateBankFilterLabel() {
        this.bankFilterIndicator.setIcon(this.inventorySetup.isFilterBank() ? BANK_FILTER_ICON : NO_BANK_FILTER_ICON);
    }

    private void updateUnorderedHighlightIndicator() {
        this.unorderedHighlightIndicator.setIcon(this.inventorySetup.isUnorderedHighlight() ? UNORDERED_HIGHLIGHT_ICON : NO_UNORDERED_HIGHLIGHT_ICON);
    }

    private void updateFavoriteIndicator() {
        this.favoriteIndicator.setIcon(this.inventorySetup.isFavorite() ? FAVORITE_ICON : NO_FAVORITE_ICON);
    }

    private void updateToggleHighlightLabel() {
        this.highlightIndicator.setIcon(this.inventorySetup.isHighlightDifference() ? TOGGLE_HIGHLIGHT_ICON : NO_TOGGLE_HIGHLIGHT_ICON);
    }

    static {
        BufferedImage bankFilterImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/filter_icon.png");
        BufferedImage bankFilterHover = ImageUtil.luminanceOffset((Image)bankFilterImg, (int)-150);
        BANK_FILTER_ICON = new ImageIcon(bankFilterImg);
        BANK_FILTER_HOVER_ICON = new ImageIcon(bankFilterHover);
        NO_BANK_FILTER_ICON = new ImageIcon(bankFilterHover);
        NO_BANK_FILTER_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)bankFilterHover, (int)-100));
        BufferedImage unorderedHighlightImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/unordered_highlight_icon.png");
        BufferedImage unorderedHighlightHover = ImageUtil.luminanceOffset((Image)unorderedHighlightImg, (int)-150);
        UNORDERED_HIGHLIGHT_ICON = new ImageIcon(unorderedHighlightImg);
        UNORDERED_HIGHLIGHT_HOVER_ICON = new ImageIcon(unorderedHighlightHover);
        NO_UNORDERED_HIGHLIGHT_ICON = new ImageIcon(unorderedHighlightHover);
        NO_UNORDERED_HIGHLIGHT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)unorderedHighlightHover, (int)-100));
        BufferedImage favoriteImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/favorite_icon.png");
        BufferedImage favoriteHover = ImageUtil.luminanceOffset((Image)favoriteImg, (int)-150);
        FAVORITE_ICON = new ImageIcon(favoriteImg);
        FAVORITE_HOVER_ICON = new ImageIcon(favoriteHover);
        NO_FAVORITE_ICON = new ImageIcon(favoriteHover);
        NO_FAVORITE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)favoriteHover, (int)-100));
        BufferedImage highlightToggleImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/highlight_icon.png");
        BufferedImage highlightToggleHover = ImageUtil.luminanceOffset((Image)highlightToggleImg, (int)-150);
        TOGGLE_HIGHLIGHT_ICON = new ImageIcon(highlightToggleImg);
        TOGGLE_HIGHLIGHT_HOVER_ICON = new ImageIcon(highlightToggleHover);
        NO_TOGGLE_HIGHLIGHT_ICON = new ImageIcon(highlightToggleHover);
        NO_TOGGLE_HIGHLIGHT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)highlightToggleHover, (int)-100));
        BufferedImage highlightImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/highlight_color_icon.png");
        BufferedImage highlightHover = ImageUtil.luminanceOffset((Image)highlightImg, (int)-150);
        HIGHLIGHT_COLOR_ICON = new ImageIcon(highlightImg);
        HIGHLIGHT_COLOR_HOVER_ICON = new ImageIcon(highlightHover);
        NO_HIGHLIGHT_COLOR_ICON = new ImageIcon(highlightHover);
        NO_HIGHLIGHT_COLOR_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)highlightHover, (int)-100));
        BufferedImage viewImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/visible_icon.png");
        BufferedImage viewImgHover = ImageUtil.luminanceOffset((Image)viewImg, (int)-150);
        VIEW_SETUP_ICON = new ImageIcon(viewImg);
        VIEW_SETUP_HOVER_ICON = new ImageIcon(viewImgHover);
        BufferedImage exportImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/export_icon.png");
        BufferedImage exportImgHover = ImageUtil.luminanceOffset((Image)exportImg, (int)-150);
        EXPORT_ICON = new ImageIcon(exportImg);
        EXPORT_HOVER_ICON = new ImageIcon(exportImgHover);
        BufferedImage deleteImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/delete_icon.png");
        DELETE_ICON = new ImageIcon(deleteImg);
        DELETE_HOVER_ICON = new ImageIcon(ImageUtil.luminanceOffset((Image)deleteImg, (int)-100));
        DISPLAY_COLOR_ICON = new ImageIcon(highlightImg);
        DISPLAY_COLOR_HOVER_ICON = new ImageIcon(highlightHover);
    }
}

