/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.ui.InventorySetupsContainerPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsSpellbookPanel
extends InventorySetupsContainerPanel {
    private InventorySetupsSlot spellbookSlot;
    private List<BufferedImage> spellbookImages = new ArrayList<BufferedImage>();

    InventorySetupsSpellbookPanel(ItemManager itemManager, InventorySetupsPlugin plugin) {
        super(itemManager, plugin, "Spellbook");
        plugin.getClientThread().invokeLater(() -> {
            BufferedImage standardSpellbook = plugin.getSpriteManager().getSprite(780, 0);
            BufferedImage ancientsSpellbook = plugin.getSpriteManager().getSprite(1583, 0);
            BufferedImage lunarSpellbook = plugin.getSpriteManager().getSprite(1584, 0);
            BufferedImage arceuusSpellbook = plugin.getSpriteManager().getSprite(1711, 0);
            Object noneSpellbook = null;
            if (standardSpellbook == null || ancientsSpellbook == null || lunarSpellbook == null || arceuusSpellbook == null) {
                return false;
            }
            this.spellbookImages.add(standardSpellbook);
            this.spellbookImages.add(ancientsSpellbook);
            this.spellbookImages.add(lunarSpellbook);
            this.spellbookImages.add(arceuusSpellbook);
            this.spellbookImages.add((BufferedImage)noneSpellbook);
            return true;
        });
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        GridLayout gridLayout = new GridLayout(1, 2, 3, 1);
        containerSlotsPanel.setLayout(gridLayout);
        this.spellbookSlot = new InventorySetupsSlot(ColorScheme.DARKER_GRAY_COLOR, InventorySetupsSlotID.SPELL_BOOK, 0);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem updateToStandard = new JMenuItem("Update Slot to Standard");
        JMenuItem updateToAncient = new JMenuItem("Update Slot to Ancient");
        JMenuItem updateToLunar = new JMenuItem("Update Slot to Lunar");
        JMenuItem updateToArceuus = new JMenuItem("Update Slot to Arceuus");
        JMenuItem updateToNone = new JMenuItem("Update Slot to None");
        popupMenu.add(updateToStandard);
        popupMenu.add(updateToAncient);
        popupMenu.add(updateToLunar);
        popupMenu.add(updateToArceuus);
        popupMenu.add(updateToNone);
        int i = 0;
        while (i < 5) {
            JMenuItem item = (JMenuItem)popupMenu.getComponent(i);
            int newSpellbook = i++;
            item.addActionListener(e -> this.plugin.updateSpellbookInSetup(newSpellbook));
        }
        this.spellbookSlot.setComponentPopupMenu(popupMenu);
        this.spellbookSlot.getImageLabel().setComponentPopupMenu(popupMenu);
        containerSlotsPanel.add(this.spellbookSlot);
    }

    @Override
    public void highlightSlots(List<InventorySetupsItem> currContainer, InventorySetup inventorySetup) {
        this.plugin.getClientThread().invokeLater(() -> {
            if (inventorySetup.getSpellBook() != 4 && inventorySetup.getSpellBook() != this.plugin.getCurrentSpellbook()) {
                this.spellbookSlot.setBackground(inventorySetup.getHighlightColor());
            } else {
                this.resetSlotColors();
            }
        });
    }

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        String spellbookStr = "";
        switch (setup.getSpellBook()) {
            case 0: {
                spellbookStr = "Standard";
                break;
            }
            case 1: {
                spellbookStr = "Ancient";
                break;
            }
            case 2: {
                spellbookStr = "Lunar";
                break;
            }
            case 3: {
                spellbookStr = "Arceuus";
                break;
            }
            case 4: {
                spellbookStr = "None";
                break;
            }
            default: {
                spellbookStr = "Incorrect";
            }
        }
        this.spellbookSlot.setImageLabel(spellbookStr + " Spellbook", this.spellbookImages.get(setup.getSpellBook()));
        this.validate();
        this.repaint();
    }

    @Override
    public void resetSlotColors() {
        this.spellbookSlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return false;
    }
}

