/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.InventorySetupsStackCompareID;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;

public class InventorySetupsSlot
extends JPanel {
    private final JLabel imageLabel;
    private final InventorySetupsSlotID slotID;
    private InventorySetup parentSetup;
    private int indexInSlot;
    private JLabel fuzzyIndicator;
    private JLabel stackIndicator;
    private JPopupMenu rightClickMenu;
    private JPopupMenu shiftRightClickMenu;

    public InventorySetupsSlot(Color color, InventorySetupsSlotID id, int indexInSlot) {
        this(color, id, indexInSlot, 46, 42);
    }

    public InventorySetupsSlot(Color color, InventorySetupsSlotID id, int indexInSlot, int width, int height) {
        this.slotID = id;
        this.imageLabel = new JLabel();
        this.parentSetup = null;
        this.fuzzyIndicator = new JLabel();
        this.stackIndicator = new JLabel();
        this.fuzzyIndicator.setFont(FontManager.getRunescapeSmallFont());
        this.stackIndicator.setFont(FontManager.getRunescapeSmallFont());
        this.indexInSlot = indexInSlot;
        this.rightClickMenu = new JPopupMenu();
        this.shiftRightClickMenu = new JPopupMenu();
        MouseAdapter menuAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopupMenu(e);
            }

            private void showPopupMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        InventorySetupsSlot.this.shiftRightClickMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        InventorySetupsSlot.this.rightClickMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.addMouseListener(menuAdapter);
        this.imageLabel.addMouseListener(menuAdapter);
        this.setPreferredSize(new Dimension(width, height));
        this.setBackground(color);
        this.setLayout(new GridBagLayout());
        GridBagConstraints fuzzyConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints stackConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add(this.imageLabel);
        this.add((Component)this.fuzzyIndicator, fuzzyConstraints);
        this.add((Component)this.stackIndicator, stackConstraints);
    }

    public void setImageLabel(String toolTip, BufferedImage itemImage, boolean isFuzzy, InventorySetupsStackCompareID stackCompare) {
        if (itemImage == null || toolTip == null) {
            this.imageLabel.setToolTipText("");
            this.imageLabel.setIcon(null);
            this.imageLabel.revalidate();
        } else {
            this.imageLabel.setToolTipText(toolTip);
            if (itemImage instanceof AsyncBufferedImage) {
                AsyncBufferedImage itemImageAsync = (AsyncBufferedImage)itemImage;
                itemImageAsync.addTo(this.imageLabel);
            } else {
                this.imageLabel.setIcon(new ImageIcon(itemImage));
            }
        }
        this.fuzzyIndicator.setText(isFuzzy ? "*" : "");
        this.stackIndicator.setText(InventorySetupsStackCompareID.getStringFromValue(stackCompare));
        this.validate();
        this.repaint();
    }

    public void setImageLabel(String toolTip, BufferedImage itemImage) {
        this.setImageLabel(toolTip, itemImage, false, InventorySetupsStackCompareID.None);
    }

    public JLabel getImageLabel() {
        return this.imageLabel;
    }

    public InventorySetupsSlotID getSlotID() {
        return this.slotID;
    }

    public InventorySetup getParentSetup() {
        return this.parentSetup;
    }

    public void setParentSetup(InventorySetup parentSetup) {
        this.parentSetup = parentSetup;
    }

    public int getIndexInSlot() {
        return this.indexInSlot;
    }

    public JLabel getFuzzyIndicator() {
        return this.fuzzyIndicator;
    }

    public JLabel getStackIndicator() {
        return this.stackIndicator;
    }

    public JPopupMenu getRightClickMenu() {
        return this.rightClickMenu;
    }

    public JPopupMenu getShiftRightClickMenu() {
        return this.shiftRightClickMenu;
    }
}

