/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsSelectionPanel {
    private final JList<String> list;
    private ActionListener okEvent;
    private ActionListener cancelEvent;
    private final JDialog dialog;

    public InventorySetupsSelectionPanel(JPanel parent, String title, String message, String[] options) {
        this.list = new JList<String>(options);
        this.list.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        JLabel label = new JLabel(message);
        JLabel ctrlClickLabel = new JLabel("Ctrl + Click to select multiple");
        JPanel topLabels = new JPanel(new BorderLayout());
        label.setHorizontalAlignment(0);
        ctrlClickLabel.setHorizontalAlignment(0);
        topLabels.add((Component)label, "North");
        topLabels.add((Component)ctrlClickLabel, "Center");
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this::handleOkButtonClick);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this::handleCancelButtonClick);
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)this.list.getCellRenderer();
        renderer.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.list);
        panel.add((Component)topLabels, "North");
        panel.add((Component)scrollPane, "Center");
        FontMetrics metrics = new FontMetrics(this.list.getFont()){};
        String longestWidthString = Arrays.stream(options).max(Comparator.comparingInt(s -> (int)Math.ceil(metrics.getStringBounds((String)s, null).getWidth()))).get();
        Rectangle2D bounds = metrics.getStringBounds(longestWidthString, null);
        this.list.setFixedCellHeight((int)Math.ceil(bounds.getHeight() + 1.0));
        int widthInPixels = (int)Math.ceil(bounds.getWidth()) + 25;
        int max_char_height = metrics.getMaxAscent() + metrics.getMaxDescent();
        int heightInPixels = max_char_height * options.length + 50;
        int maxHeight = 400;
        int maxWidth = 500;
        panel.setPreferredSize(new Dimension(Math.min(widthInPixels, maxWidth), Math.min(heightInPixels, maxHeight)));
        JOptionPane optionPane = new JOptionPane(panel);
        optionPane.setOptions(new Object[]{okButton, cancelButton});
        this.dialog = optionPane.createDialog(parent, "Select option");
        this.dialog.setIconImage(new BufferedImage(1, 1, 3));
        this.dialog.setTitle(title);
    }

    public void setOnOk(ActionListener event) {
        this.okEvent = event;
    }

    public void setOnClose(ActionListener event) {
        this.cancelEvent = event;
    }

    private void handleOkButtonClick(ActionEvent e) {
        if (this.okEvent != null) {
            this.okEvent.actionPerformed(e);
        }
        this.hide();
    }

    private void handleCancelButtonClick(ActionEvent e) {
        if (this.cancelEvent != null) {
            this.cancelEvent.actionPerformed(e);
        }
        this.hide();
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    private void hide() {
        this.dialog.setVisible(false);
    }

    public List<String> getSelectedItems() {
        return this.list.getSelectedValuesList();
    }
}

