/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsPanelViewID;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSection;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.InventorySetupsSortingID;
import inventorysetups.InventorySetupsValidName;
import inventorysetups.ui.InventorySetupsCompactPanel;
import inventorysetups.ui.InventorySetupsIconPanel;
import inventorysetups.ui.InventorySetupsMoveHandler;
import inventorysetups.ui.InventorySetupsMoveMenu;
import inventorysetups.ui.InventorySetupsNameActions;
import inventorysetups.ui.InventorySetupsPanel;
import inventorysetups.ui.InventorySetupsPluginPanel;
import inventorysetups.ui.InventorySetupsSelectionPanel;
import inventorysetups.ui.InventorySetupsSlot;
import inventorysetups.ui.InventorySetupsStandardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class InventorySetupsSectionPanel
extends JPanel
implements InventorySetupsValidName,
InventorySetupsMoveHandler<InventorySetupsSection> {
    protected final InventorySetupsPlugin plugin;
    protected final InventorySetupsPluginPanel panel;
    private final InventorySetupsSection section;
    private final JPanel panelWithSetups;
    private final JLabel minMaxLabel;
    private static final ImageIcon MIN_MAX_SECTION_ICON;
    private static final ImageIcon MIN_MAX_SECTION_HOVER_ICON;
    private static final ImageIcon NO_MIN_MAX_SECTION_ICON;
    private static final ImageIcon NO_MIN_MAX_SECTION_HOVER_ICON;
    private boolean forceMaximization;
    private boolean allowEditable;
    public static final int MAX_ICONS_PER_ROW = 4;

    InventorySetupsSectionPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, final InventorySetupsSection section, final boolean forceMaximization, boolean allowEdits, Set<String> setupNamesToBeDisplayed, Set<String> setupsInSection, List<InventorySetup> originalFilteredSetups) {
        this.plugin = plugin;
        this.panel = panel;
        this.section = section;
        this.forceMaximization = forceMaximization;
        this.allowEditable = allowEdits;
        this.panelWithSetups = new JPanel();
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.minMaxLabel = new JLabel();
        this.updateMinMaxLabel();
        this.minMaxLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                InventorySetupsSectionPanel.this.maximizationRequest(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (forceMaximization) {
                    return;
                }
                InventorySetupsSectionPanel.this.minMaxLabel.setIcon(section.isMaximized() ? MIN_MAX_SECTION_HOVER_ICON : NO_MIN_MAX_SECTION_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (forceMaximization) {
                    return;
                }
                InventorySetupsSectionPanel.this.minMaxLabel.setIcon(section.isMaximized() ? MIN_MAX_SECTION_ICON : NO_MIN_MAX_SECTION_ICON);
            }
        });
        InventorySetupsMoveMenu<InventorySetupsSection> popupMenu = new InventorySetupsMoveMenu<InventorySetupsSection>(plugin, panel, this, "Section", section);
        JMenuItem exportSection = new JMenuItem("Export Section");
        JMenuItem addSetupsToSection = new JMenuItem("Add setups to section..");
        JMenuItem deleteSection = new JMenuItem("Delete Section..");
        exportSection.addActionListener(e -> plugin.exportSection(section));
        addSetupsToSection.addActionListener(e -> {
            String[] setupNames = (String[])plugin.getInventorySetups().stream().map(InventorySetup::getName).toArray(String[]::new);
            Arrays.sort(setupNames, String.CASE_INSENSITIVE_ORDER);
            String message = "Select setups to add to this section";
            String title = "Select Setups";
            InventorySetupsSelectionPanel selectionDialog = new InventorySetupsSelectionPanel((JPanel)((Object)panel), "Select Setups", "Select setups to add to this section", setupNames);
            selectionDialog.setOnOk(e1 -> {
                List<String> selectedSetups = selectionDialog.getSelectedItems();
                if (!selectedSetups.isEmpty()) {
                    plugin.addSetupsToSection(section, selectedSetups);
                }
            });
            selectionDialog.show();
        });
        deleteSection.addActionListener(e -> plugin.removeSection(section));
        popupMenu.add(addSetupsToSection);
        popupMenu.add(exportSection);
        popupMenu.add(deleteSection);
        MouseAdapter flatTextFieldMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                InventorySetupsSectionPanel.this.maximizationRequest(mouseEvent);
            }
        };
        Color nameWrapperColor = new Color(20, 20, 20);
        InventorySetupsNameActions<InventorySetupsSection> nameActions = new InventorySetupsNameActions<InventorySetupsSection>(section, plugin, panel, this, popupMenu, 50, nameWrapperColor, this.allowEditable, flatTextFieldMouseAdapter);
        JPanel westNameActions = new JPanel(new BorderLayout());
        westNameActions.setBackground(nameWrapperColor);
        westNameActions.add(Box.createRigidArea(new Dimension(6, 0)), "West");
        westNameActions.add((Component)this.minMaxLabel, "Center");
        nameActions.add((Component)westNameActions, "West");
        JPanel nameWrapper = new JPanel();
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setLayout(new BorderLayout());
        nameWrapper.add(nameActions, "Center");
        if (this.allowEditable) {
            nameWrapper.setComponentPopupMenu(popupMenu);
        }
        this.add((Component)nameWrapper, "North");
        this.addSetups(setupNamesToBeDisplayed, setupsInSection, originalFilteredSetups, this.allowEditable);
    }

    private void maximizationRequest(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.allowEditable && !this.forceMaximization) {
                this.section.setMaximized(!this.section.isMaximized());
                this.plugin.getDataManager().updateConfig(false, true);
                this.panel.redrawOverviewPanel(false);
            } else {
                this.plugin.setConfigValue("unassignedMaximized", !this.section.isMaximized());
            }
        }
    }

    private void addSetups(Set<String> setupNamesToBeDisplayed, Set<String> setupsInSection, List<InventorySetup> originalFilteredSetups, boolean allowEditable) {
        if (this.section.isMaximized() || this.forceMaximization) {
            this.panelWithSetups.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            if (this.plugin.getConfig().sortingMode() == InventorySetupsSortingID.DEFAULT) {
                if (this.plugin.getConfig().panelView() == InventorySetupsPanelViewID.ICON) {
                    List<InventorySetup> setupObjectsInSection = this.section.getSetups().stream().map(setupName -> this.plugin.getCache().getInventorySetupNames().get(setupName)).collect(Collectors.toList());
                    JPanel iconGridPanel = InventorySetupsSectionPanel.createIconPanelGrid(this.plugin, this.panel, setupObjectsInSection, 4, setupNamesToBeDisplayed, this.section, allowEditable);
                    this.panelWithSetups.add((Component)iconGridPanel, constraints);
                    ++constraints.gridy;
                } else {
                    this.panelWithSetups.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
                    ++constraints.gridy;
                    for (String name : this.section.getSetups()) {
                        if (!setupNamesToBeDisplayed.contains(name)) continue;
                        InventorySetup setupInSection = this.plugin.getCache().getInventorySetupNames().get(name);
                        this.createSetupPanelForSection(setupInSection, this.section, constraints, allowEditable);
                    }
                }
            } else if (this.plugin.getConfig().panelView() == InventorySetupsPanelViewID.ICON) {
                JPanel iconGridPanel = InventorySetupsSectionPanel.createIconPanelGrid(this.plugin, this.panel, originalFilteredSetups, 4, setupsInSection, this.section, allowEditable);
                this.panelWithSetups.add((Component)iconGridPanel, constraints);
                ++constraints.gridy;
            } else {
                this.panelWithSetups.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
                ++constraints.gridy;
                for (InventorySetup setup : originalFilteredSetups) {
                    if (!setupsInSection.contains(setup.getName())) continue;
                    this.createSetupPanelForSection(setup, this.section, constraints, allowEditable);
                }
            }
            this.add((Component)this.panelWithSetups, "South");
        }
    }

    private void createSetupPanelForSection(InventorySetup setupInSection, InventorySetupsSection section, GridBagConstraints constraints, boolean allowEditable) {
        JPanel wrapperPanelForSetup = new JPanel();
        wrapperPanelForSetup.setLayout(new BorderLayout());
        InventorySetupsPanel newPanel = null;
        newPanel = this.plugin.getConfig().panelView() == InventorySetupsPanelViewID.COMPACT ? new InventorySetupsCompactPanel(this.plugin, this.panel, setupInSection, section, allowEditable) : new InventorySetupsStandardPanel(this.plugin, this.panel, setupInSection, section, allowEditable);
        wrapperPanelForSetup.add(Box.createRigidArea(new Dimension(12, 0)), "West");
        wrapperPanelForSetup.add((Component)newPanel, "Center");
        this.panelWithSetups.add((Component)wrapperPanelForSetup, constraints);
        ++constraints.gridy;
        this.panelWithSetups.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
        ++constraints.gridy;
    }

    public static JPanel createIconPanelGrid(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, List<InventorySetup> setups, int maxColSize, Set<String> whitelistedNames, InventorySetupsSection section, boolean allowEditable) {
        int added = 0;
        int width = 0;
        int height = 0;
        JPanel wrapperPanel = new JPanel(new GridLayout(0, maxColSize, 5, 5));
        for (InventorySetup setup : setups) {
            if (whitelistedNames != null && !whitelistedNames.contains(setup.getName())) continue;
            InventorySetupsIconPanel newPanel = new InventorySetupsIconPanel(plugin, panel, setup, section, allowEditable);
            width = newPanel.getWidth();
            height = newPanel.getHeight();
            wrapperPanel.add(newPanel);
            ++added;
        }
        return InventorySetupsSectionPanel.addExtraIconSlotsAndExpansionStopper(wrapperPanel, added, maxColSize, width, height);
    }

    public static JPanel addExtraIconSlotsAndExpansionStopper(JPanel iconGridPanel, int size, int maxColSize, int width, int height) {
        int i = size;
        while (i % maxColSize != 0) {
            iconGridPanel.add(new InventorySetupsSlot(ColorScheme.DARK_GRAY_COLOR, InventorySetupsSlotID.INVENTORY, -1, width, height));
            ++i;
        }
        JPanel stopExpansionLayout = new JPanel(new FlowLayout());
        stopExpansionLayout.add(iconGridPanel);
        return stopExpansionLayout;
    }

    @Override
    public boolean isNameValid(String name) {
        return !name.isEmpty() && !this.plugin.getCache().getSectionNames().containsKey(name) && !this.section.getName().equals(name);
    }

    @Override
    public void updateName(String newName) {
        this.plugin.updateSectionName(this.section, newName);
    }

    private void updateMinMaxLabel() {
        if (this.forceMaximization) {
            this.minMaxLabel.setToolTipText("");
            this.minMaxLabel.setIcon(MIN_MAX_SECTION_ICON);
        } else {
            this.minMaxLabel.setToolTipText(this.section.isMaximized() ? "Minimize section" : "Maximize section");
            this.minMaxLabel.setIcon(this.section.isMaximized() ? MIN_MAX_SECTION_ICON : NO_MIN_MAX_SECTION_ICON);
        }
    }

    @Override
    public void moveUp(InventorySetupsSection section) {
        int sectionIndex = this.plugin.getSections().indexOf(section);
        this.plugin.moveSection(sectionIndex, sectionIndex - 1);
    }

    @Override
    public void moveDown(InventorySetupsSection section) {
        int sectionIndex = this.plugin.getSections().indexOf(section);
        this.plugin.moveSection(sectionIndex, sectionIndex + 1);
    }

    @Override
    public void moveToTop(InventorySetupsSection section) {
        int sectionIndex = this.plugin.getSections().indexOf(section);
        this.plugin.moveSection(sectionIndex, 0);
    }

    @Override
    public void moveToBottom(InventorySetupsSection section) {
        int sectionIndex = this.plugin.getSections().indexOf(section);
        this.plugin.moveSection(sectionIndex, this.plugin.getSections().size() - 1);
    }

    @Override
    public void moveToPosition(InventorySetupsSection section) {
        int sectionIndex = this.plugin.getSections().indexOf(section);
        String posDialog = "Enter a position between 1 and " + String.valueOf(this.plugin.getSections().size()) + ". Current section is in position " + String.valueOf(sectionIndex + 1) + ".";
        String newPositionStr = JOptionPane.showInputDialog((Component)((Object)this.panel), posDialog, "Move Section", -1);
        if (newPositionStr == null) {
            return;
        }
        try {
            int newPosition = Integer.parseInt(newPositionStr);
            if (newPosition < 1 || newPosition > this.plugin.getSections().size()) {
                JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid position.", "Move Section Failed", 0);
                return;
            }
            this.plugin.moveSection(sectionIndex, newPosition - 1);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid position.", "Move Section Failed", 0);
        }
    }

    static {
        BufferedImage minMaxSectionImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/down_arrow.png");
        BufferedImage minMaxSectionHoverImg = ImageUtil.luminanceOffset((Image)minMaxSectionImg, (int)-150);
        MIN_MAX_SECTION_ICON = new ImageIcon(minMaxSectionImg);
        MIN_MAX_SECTION_HOVER_ICON = new ImageIcon(minMaxSectionHoverImg);
        BufferedImage noMinMaxSectionImg = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/right_arrow.png");
        BufferedImage noMaxSectionHoverImg = ImageUtil.luminanceOffset((Image)noMinMaxSectionImg, (int)-150);
        NO_MIN_MAX_SECTION_ICON = new ImageIcon(noMinMaxSectionImg);
        NO_MIN_MAX_SECTION_HOVER_ICON = new ImageIcon(noMaxSectionHoverImg);
    }
}

