/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupUtilities;
import inventorysetups.InventorySetupsFilteringModeID;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPanelViewID;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSection;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.InventorySetupsSortingID;
import inventorysetups.ui.InventorySetupsAdditionalItemsPanel;
import inventorysetups.ui.InventorySetupsBoltPouchPanel;
import inventorysetups.ui.InventorySetupsCompactPanel;
import inventorysetups.ui.InventorySetupsCycleButton;
import inventorysetups.ui.InventorySetupsEquipmentPanel;
import inventorysetups.ui.InventorySetupsInventoryPanel;
import inventorysetups.ui.InventorySetupsNotesPanel;
import inventorysetups.ui.InventorySetupsPanel;
import inventorysetups.ui.InventorySetupsRunePouchPanel;
import inventorysetups.ui.InventorySetupsSectionPanel;
import inventorysetups.ui.InventorySetupsSpellbookPanel;
import inventorysetups.ui.InventorySetupsStandardPanel;
import inventorysetups.ui.InventorySetupsUpdateNewsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.InventoryID;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class InventorySetupsPluginPanel
extends PluginPanel {
    private static ImageIcon HELP_ICON;
    private static ImageIcon HELP_HOVER_ICON;
    private static ImageIcon STANDARD_VIEW_ICON;
    private static ImageIcon STANDARD_VIEW_HOVER_ICON;
    private static ImageIcon COMPACT_VIEW_ICON;
    private static ImageIcon COMPACT_VIEW_HOVER_ICON;
    private static ImageIcon ICON_VIEW_ICON;
    private static ImageIcon ICON_VIEW_HOVER_ICON;
    private static ImageIcon SECTION_VIEW_ICON;
    private static ImageIcon SECTION_VIEW_HOVER_ICON;
    private static ImageIcon NO_SECTION_VIEW_ICON;
    private static ImageIcon NO_SECTION_VIEW_HOVER_ICON;
    private static ImageIcon ALPHABETICAL_ICON;
    private static ImageIcon ALPHABETICAL_HOVER_ICON;
    private static ImageIcon NO_ALPHABETICAL_ICON;
    private static ImageIcon NO_ALPHABETICAL_HOVER_ICON;
    private static ImageIcon ADD_ICON;
    private static ImageIcon ADD_HOVER_ICON;
    private static ImageIcon BACK_ICON;
    private static ImageIcon BACK_HOVER_ICON;
    private static ImageIcon IMPORT_ICON;
    private static ImageIcon IMPORT_HOVER_ICON;
    private static ImageIcon UPDATE_ICON;
    private static ImageIcon UPDATE_HOVER_ICON;
    private static String MAIN_TITLE;
    private final JPanel noSetupsPanel;
    private final JPanel updateNewsPanel;
    private final JPanel setupDisplayPanel;
    private final JPanel overviewPanel;
    private final JPanel northAnchoredPanel;
    private final JScrollPane contentWrapperPane;
    private final JPanel overviewTopPanel;
    private final JPanel setupTopPanel;
    private final JLabel mainTitle;
    private final JLabel setupTitle;
    private final JLabel helpButton;
    private final InventorySetupsCycleButton<InventorySetupsPanelViewID> panelViewMarker;
    private final JLabel sortingMarker;
    private final JLabel sectionViewMarker;
    private final JLabel addMarker;
    private final JLabel importMarker;
    private final JLabel updateMarker;
    private final JLabel backMarker;
    private final IconTextField searchBar;
    private final InventorySetupsInventoryPanel inventoryPanel;
    private final InventorySetupsEquipmentPanel equipmentPanel;
    private final InventorySetupsRunePouchPanel runePouchPanel;
    private final InventorySetupsBoltPouchPanel boltPouchPanel;
    private final InventorySetupsSpellbookPanel spellbookPanel;
    private final InventorySetupsAdditionalItemsPanel additionalFilteredItemsPanel;
    private final InventorySetupsNotesPanel notesPanel;
    private InventorySetup currentSelectedSetup = null;
    private int overviewPanelScrollPosition;
    private final InventorySetupsPlugin plugin;
    private List<InventorySetup> filteredInventorysetups;

    public InventorySetupsPluginPanel(final InventorySetupsPlugin plugin, ItemManager itemManager) {
        super(false);
        this.plugin = plugin;
        this.runePouchPanel = new InventorySetupsRunePouchPanel(itemManager, plugin);
        this.boltPouchPanel = new InventorySetupsBoltPouchPanel(itemManager, plugin);
        this.inventoryPanel = new InventorySetupsInventoryPanel(itemManager, plugin, this.runePouchPanel, this.boltPouchPanel);
        this.equipmentPanel = new InventorySetupsEquipmentPanel(itemManager, plugin);
        this.spellbookPanel = new InventorySetupsSpellbookPanel(itemManager, plugin);
        this.additionalFilteredItemsPanel = new InventorySetupsAdditionalItemsPanel(itemManager, plugin);
        this.notesPanel = new InventorySetupsNotesPanel(itemManager, plugin);
        this.noSetupsPanel = new JPanel();
        this.updateNewsPanel = new InventorySetupsUpdateNewsPanel(plugin, this);
        this.setupDisplayPanel = new JPanel();
        this.overviewPanel = new JPanel();
        this.overviewTopPanel = new JPanel();
        this.overviewPanelScrollPosition = 0;
        this.filteredInventorysetups = new ArrayList<InventorySetup>();
        this.mainTitle = new JLabel();
        this.mainTitle.setText(MAIN_TITLE);
        this.mainTitle.setForeground(Color.WHITE);
        this.helpButton = new JLabel(HELP_ICON);
        this.helpButton.setToolTipText("Click for help. This button can be hidden in the config.");
        this.helpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    LinkBrowser.browse((String)"https://github.com/dillydill123/inventory-setups#inventory-setups");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.helpButton.setIcon(HELP_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.helpButton.setIcon(HELP_ICON);
            }
        });
        this.sortingMarker = new JLabel(ALPHABETICAL_ICON);
        this.sortingMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    boolean isAlphabeticalMode = plugin.getConfig().sortingMode() == InventorySetupsSortingID.ALPHABETICAL;
                    plugin.toggleAlphabeticalMode(isAlphabeticalMode ? InventorySetupsSortingID.DEFAULT : InventorySetupsSortingID.ALPHABETICAL);
                    InventorySetupsPluginPanel.this.updateSortingMarker();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                boolean isAlphabeticalMode = plugin.getConfig().sortingMode() == InventorySetupsSortingID.ALPHABETICAL;
                InventorySetupsPluginPanel.this.sortingMarker.setIcon(isAlphabeticalMode ? ALPHABETICAL_HOVER_ICON : NO_ALPHABETICAL_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                boolean isAlphabeticalMode = plugin.getConfig().sortingMode() == InventorySetupsSortingID.ALPHABETICAL;
                InventorySetupsPluginPanel.this.sortingMarker.setIcon(isAlphabeticalMode ? ALPHABETICAL_ICON : NO_ALPHABETICAL_ICON);
            }
        });
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>(Arrays.asList(STANDARD_VIEW_ICON, COMPACT_VIEW_ICON, ICON_VIEW_ICON));
        ArrayList<ImageIcon> hoverIcons = new ArrayList<ImageIcon>(Arrays.asList(STANDARD_VIEW_HOVER_ICON, COMPACT_VIEW_HOVER_ICON, ICON_VIEW_HOVER_ICON));
        ArrayList<String> tooltips = new ArrayList<String>(Arrays.asList("Switch to compact mode", "Switch to icon mode", "Switch to standard mode"));
        this.panelViewMarker = new InventorySetupsCycleButton<InventorySetupsPanelViewID>(plugin, InventorySetupsPanelViewID.getValues(), icons, hoverIcons, tooltips);
        Runnable r = () -> plugin.setConfigValue("panelView", this.panelViewMarker.getCurrentState().toString());
        this.panelViewMarker.setRunnable(r);
        JPopupMenu massImportExportMenu = new JPopupMenu();
        JMenuItem massImportSetupsMenu = new JMenuItem("Mass Import Setups");
        JMenuItem massExportSetupsMenu = new JMenuItem("Mass Export Setups");
        JMenuItem massImportSectionsMenu = new JMenuItem("Mass Import Sections");
        JMenuItem massExportSectionsMenu = new JMenuItem("Mass Export Sections");
        massImportExportMenu.add(massImportSetupsMenu);
        massImportExportMenu.add(massExportSetupsMenu);
        massImportExportMenu.add(massImportSectionsMenu);
        massImportExportMenu.add(massExportSectionsMenu);
        massImportSetupsMenu.addActionListener(e -> plugin.massImportSetups());
        massExportSetupsMenu.addActionListener(e -> plugin.massExport(plugin.getInventorySetups(), "Setups", "inventory_setups"));
        massImportSectionsMenu.addActionListener(e -> plugin.massImportSections());
        massExportSectionsMenu.addActionListener(e -> plugin.massExport(plugin.getSections(), "Sections", "sections"));
        final JPopupMenu singleImportExportMenu = new JPopupMenu();
        JMenuItem singleImportSetupMenu = new JMenuItem("Import setup..");
        JMenuItem singleImportSectionMenu = new JMenuItem("Import section..");
        singleImportExportMenu.add(singleImportSetupMenu);
        singleImportExportMenu.add(singleImportSectionMenu);
        singleImportSetupMenu.addActionListener(e -> plugin.importSetup());
        singleImportSectionMenu.addActionListener(e -> plugin.importSection());
        this.importMarker = new JLabel(IMPORT_ICON);
        this.importMarker.setToolTipText("Import a new setup or section");
        this.importMarker.setComponentPopupMenu(massImportExportMenu);
        this.importMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point location = MouseInfo.getPointerInfo().getLocation();
                    SwingUtilities.convertPointFromScreen(location, InventorySetupsPluginPanel.this.importMarker);
                    singleImportExportMenu.show(InventorySetupsPluginPanel.this.importMarker, location.x, location.y);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.importMarker.setIcon(IMPORT_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.importMarker.setIcon(IMPORT_ICON);
            }
        });
        this.addMarker = new JLabel(ADD_ICON);
        this.addMarker.setToolTipText("Add new setup or section");
        final JPopupMenu addMarkerMenu = new JPopupMenu();
        JMenuItem addMarkerAddNewSetup = new JMenuItem("Add new setup..");
        JMenuItem addMarkerAddNewSection = new JMenuItem("Add new section..");
        addMarkerMenu.add(addMarkerAddNewSetup);
        addMarkerMenu.add(addMarkerAddNewSection);
        addMarkerAddNewSetup.addActionListener(e -> plugin.addInventorySetup());
        addMarkerAddNewSection.addActionListener(e -> plugin.addSection());
        this.addMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point location = MouseInfo.getPointerInfo().getLocation();
                    SwingUtilities.convertPointFromScreen(location, InventorySetupsPluginPanel.this.addMarker);
                    addMarkerMenu.show(InventorySetupsPluginPanel.this.addMarker, location.x, location.y);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.addMarker.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.addMarker.setIcon(ADD_ICON);
            }
        });
        this.updateMarker = new JLabel(UPDATE_ICON);
        this.updateMarker.setToolTipText("Update setup with current inventory and equipment");
        this.updateMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    plugin.updateCurrentSetup(InventorySetupsPluginPanel.this.currentSelectedSetup);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.updateMarker.setIcon(UPDATE_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.updateMarker.setIcon(UPDATE_ICON);
            }
        });
        this.backMarker = new JLabel(BACK_ICON);
        this.backMarker.setToolTipText("Return to setups");
        this.backMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InventorySetupsPluginPanel.this.returnToOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.backMarker.setIcon(BACK_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.backMarker.setIcon(BACK_ICON);
            }
        });
        this.sectionViewMarker = new JLabel(COMPACT_VIEW_ICON);
        this.sectionViewMarker.setToolTipText("Switch to section mode");
        this.sectionViewMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InventorySetupsPluginPanel.this.toggleSectionMode();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsPluginPanel.this.sectionViewMarker.setIcon(plugin.getConfig().sectionMode() ? SECTION_VIEW_HOVER_ICON : NO_SECTION_VIEW_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsPluginPanel.this.sectionViewMarker.setIcon(plugin.getConfig().sectionMode() ? SECTION_VIEW_ICON : NO_SECTION_VIEW_ICON);
            }
        });
        JPanel overViewMarkers = new JPanel(new FlowLayout(0, 0, 0));
        overViewMarkers.add(this.sectionViewMarker);
        overViewMarkers.add(this.sortingMarker);
        overViewMarkers.add(this.panelViewMarker);
        overViewMarkers.add(this.importMarker);
        overViewMarkers.add(this.addMarker);
        this.sortingMarker.setBorder(new EmptyBorder(0, 8, 0, 0));
        this.panelViewMarker.setBorder(new EmptyBorder(0, 8, 0, 0));
        this.importMarker.setBorder(new EmptyBorder(0, 8, 0, 0));
        this.addMarker.setBorder(new EmptyBorder(0, 8, 0, 0));
        JPanel overviewTitleAndHelpButton = new JPanel();
        overviewTitleAndHelpButton.setLayout(new BorderLayout());
        overviewTitleAndHelpButton.add((Component)this.mainTitle, "West");
        overviewTitleAndHelpButton.add((Component)this.helpButton, "East");
        JPanel setupViewMarkers = new JPanel(new FlowLayout(2, 0, 0));
        setupViewMarkers.add(this.updateMarker);
        setupViewMarkers.add(this.backMarker);
        this.backMarker.setBorder(new EmptyBorder(0, 8, 0, 0));
        this.setupTitle = new JLabel();
        this.setupTitle.setForeground(Color.WHITE);
        JPanel setupTitleAndButtons = new JPanel();
        setupTitleAndButtons.setLayout(new BorderLayout());
        setupTitleAndButtons.add((Component)this.setupTitle, "West");
        setupTitleAndButtons.add((Component)setupViewMarkers, "East");
        this.setupTopPanel = new JPanel(new BorderLayout());
        this.setupTopPanel.add((Component)setupTitleAndButtons, "Center");
        this.overviewTopPanel.setLayout(new BorderLayout());
        this.overviewTopPanel.add((Component)overviewTitleAndHelpButton, "North");
        this.overviewTopPanel.add(Box.createRigidArea(new Dimension(0, 3)), "Center");
        this.overviewTopPanel.add((Component)overViewMarkers, "South");
        this.overviewTopPanel.setVisible(true);
        this.setupTopPanel.setVisible(false);
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(205, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.setMinimumSize(new Dimension(0, 30));
        this.searchBar.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                InventorySetupsPluginPanel.this.redrawOverviewPanel(true);
            }
        });
        this.searchBar.addClearListener(() -> this.redrawOverviewPanel(true));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)this.overviewTopPanel, "North");
        topPanel.add((Component)this.setupTopPanel, "South");
        this.northAnchoredPanel = new JPanel();
        this.northAnchoredPanel.setLayout(new BoxLayout(this.northAnchoredPanel, 1));
        this.northAnchoredPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.northAnchoredPanel.add(topPanel);
        this.northAnchoredPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.northAnchoredPanel.add((Component)this.searchBar);
        BoxLayout invEqLayout = new BoxLayout(this.setupDisplayPanel, 1);
        this.setupDisplayPanel.setLayout(invEqLayout);
        this.setupDisplayPanel.add(this.inventoryPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.runePouchPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.boltPouchPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.equipmentPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.spellbookPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.additionalFilteredItemsPanel);
        this.setupDisplayPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.setupDisplayPanel.add(this.notesPanel);
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setContent("Inventory Setups", "Create an inventory setup.");
        this.noSetupsPanel.add((Component)errorPanel);
        JPanel contentPanel = new JPanel();
        BoxLayout contentLayout = new BoxLayout(contentPanel, 1);
        contentPanel.setLayout(contentLayout);
        contentPanel.add(this.setupDisplayPanel);
        contentPanel.add(this.noSetupsPanel);
        contentPanel.add(this.updateNewsPanel);
        contentPanel.add(this.overviewPanel);
        JPanel contentWrapper = new JPanel(new BorderLayout());
        contentWrapper.add(Box.createGlue(), "Center");
        contentWrapper.add((Component)contentPanel, "North");
        this.contentWrapperPane = new JScrollPane(contentWrapper);
        this.contentWrapperPane.setHorizontalScrollBarPolicy(31);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(this.northAnchoredPanel, "North");
        this.add(this.contentWrapperPane, "Center");
        this.setupDisplayPanel.setVisible(false);
        this.helpButton.setVisible(!plugin.getConfig().hideButton());
        this.updateSectionViewMarker();
        this.updatePanelViewMarker();
        this.updateSortingMarker();
    }

    public void redrawOverviewPanel(boolean resetScrollBar) {
        this.returnToOverviewPanel(resetScrollBar);
        InventorySetupUtilities.fastRemoveAll(this.overviewPanel);
        this.updateSectionViewMarker();
        this.updatePanelViewMarker();
        this.updateSortingMarker();
        this.filteredInventorysetups.clear();
        if (!this.searchBar.getText().isEmpty()) {
            this.filteredInventorysetups = this.plugin.filterSetups(this.searchBar.getText());
        } else {
            this.filteredInventorysetups = new ArrayList<InventorySetup>(this.plugin.getInventorySetups());
            this.moveFavoriteSetupsToTopOfList(this.filteredInventorysetups);
        }
        if (this.plugin.getConfig().sortingMode() == InventorySetupsSortingID.ALPHABETICAL) {
            this.filteredInventorysetups.sort(Comparator.comparing(InventorySetup::getName, String.CASE_INSENSITIVE_ORDER));
        }
        this.layoutSetups(this.filteredInventorysetups);
        this.revalidate();
        this.repaint();
    }

    public void moveFavoriteSetupsToTopOfList(List<InventorySetup> setupsToAdd) {
        List favSetups = setupsToAdd.stream().filter(InventorySetup::isFavorite).collect(Collectors.toList());
        setupsToAdd.removeAll(favSetups);
        for (int i = favSetups.size() - 1; i >= 0; --i) {
            setupsToAdd.add(0, (InventorySetup)favSetups.get(i));
        }
    }

    public void refreshCurrentSetup() {
        if (this.currentSelectedSetup != null) {
            this.setCurrentInventorySetup(this.currentSelectedSetup, false);
        }
    }

    public void setCurrentInventorySetup(InventorySetup inventorySetup, boolean resetScrollBar) {
        this.overviewPanelScrollPosition = this.contentWrapperPane.getVerticalScrollBar().getValue();
        this.currentSelectedSetup = inventorySetup;
        this.inventoryPanel.updatePanelWithSetupInformation(inventorySetup);
        this.runePouchPanel.updatePanelWithSetupInformation(inventorySetup);
        this.boltPouchPanel.updatePanelWithSetupInformation(inventorySetup);
        this.equipmentPanel.updatePanelWithSetupInformation(inventorySetup);
        this.spellbookPanel.updatePanelWithSetupInformation(inventorySetup);
        this.additionalFilteredItemsPanel.updatePanelWithSetupInformation(inventorySetup);
        this.notesPanel.updatePanelWithSetupInformation(inventorySetup);
        this.overviewTopPanel.setVisible(false);
        this.setupTopPanel.setVisible(true);
        this.setupDisplayPanel.setVisible(true);
        this.noSetupsPanel.setVisible(false);
        this.overviewPanel.setVisible(false);
        this.setupTitle.setText(inventorySetup.getName());
        this.helpButton.setVisible(false);
        this.searchBar.setVisible(false);
        this.runePouchPanel.setVisible(this.currentSelectedSetup.getRune_pouch() != null);
        this.boltPouchPanel.setVisible(this.currentSelectedSetup.getBoltPouch() != null);
        this.highlightInventory();
        this.highlightEquipment();
        this.highlightSpellbook();
        if (resetScrollBar) {
            this.setScrollBarPosition(0);
        }
        this.plugin.setBankFilteringMode(InventorySetupsFilteringModeID.ALL);
        this.plugin.doBankSearch();
        this.validate();
        this.repaint();
    }

    public void highlightInventory() {
        if (!this.setupDisplayPanel.isVisible()) {
            return;
        }
        if (!this.currentSelectedSetup.isHighlightDifference() || !this.plugin.isHighlightingAllowed()) {
            this.inventoryPanel.resetSlotColors();
            return;
        }
        List<InventorySetupsItem> inv = this.plugin.getNormalizedContainer(InventoryID.INVENTORY);
        this.inventoryPanel.highlightSlots(inv, this.currentSelectedSetup);
    }

    public void highlightEquipment() {
        if (!this.setupDisplayPanel.isVisible()) {
            return;
        }
        if (!this.currentSelectedSetup.isHighlightDifference() || !this.plugin.isHighlightingAllowed()) {
            this.equipmentPanel.resetSlotColors();
            return;
        }
        List<InventorySetupsItem> eqp = this.plugin.getNormalizedContainer(InventoryID.EQUIPMENT);
        this.equipmentPanel.highlightSlots(eqp, this.currentSelectedSetup);
    }

    public void highlightSpellbook() {
        if (!this.setupDisplayPanel.isVisible()) {
            return;
        }
        if (!this.currentSelectedSetup.isHighlightDifference() || !this.plugin.isHighlightingAllowed()) {
            this.spellbookPanel.resetSlotColors();
            return;
        }
        this.spellbookPanel.highlightSlots(new ArrayList<InventorySetupsItem>(), this.currentSelectedSetup);
    }

    public void returnToOverviewPanel(boolean shouldResetScrollBar) {
        this.noSetupsPanel.setVisible(this.plugin.getInventorySetups().isEmpty() && !this.plugin.getConfig().sectionMode());
        this.overviewPanel.setVisible(!this.plugin.getInventorySetups().isEmpty() || this.plugin.getConfig().sectionMode());
        this.setupDisplayPanel.setVisible(false);
        this.overviewTopPanel.setVisible(true);
        this.setupTopPanel.setVisible(false);
        this.helpButton.setVisible(!this.plugin.getConfig().hideButton());
        this.searchBar.setVisible(true);
        if (shouldResetScrollBar) {
            this.overviewPanelScrollPosition = 0;
            this.setScrollBarPosition(this.overviewPanelScrollPosition);
        } else if (this.currentSelectedSetup != null) {
            this.setScrollBarPosition(this.overviewPanelScrollPosition);
        }
        this.currentSelectedSetup = null;
        this.plugin.resetBankSearch(true);
    }

    public boolean isStackCompareForSlotAllowed(InventorySetupsSlotID inventoryID, int slotId) {
        switch (inventoryID) {
            case INVENTORY: {
                return this.inventoryPanel.isStackCompareForSlotAllowed(slotId);
            }
            case EQUIPMENT: {
                return this.equipmentPanel.isStackCompareForSlotAllowed(slotId);
            }
            case RUNE_POUCH: {
                return this.runePouchPanel.isStackCompareForSlotAllowed(slotId);
            }
            case BOLT_POUCH: {
                return this.boltPouchPanel.isStackCompareForSlotAllowed(slotId);
            }
            case ADDITIONAL_ITEMS: {
                return this.additionalFilteredItemsPanel.isStackCompareForSlotAllowed(slotId);
            }
            case SPELL_BOOK: {
                return this.spellbookPanel.isStackCompareForSlotAllowed(slotId);
            }
        }
        return false;
    }

    public void toggleSectionMode() {
        this.plugin.setConfigValue("sectionMode", !this.plugin.getConfig().sectionMode());
        this.updateSectionViewMarker();
    }

    private void updateSectionViewMarker() {
        this.sectionViewMarker.setIcon(this.plugin.getConfig().sectionMode() ? SECTION_VIEW_ICON : NO_SECTION_VIEW_ICON);
        this.sectionViewMarker.setToolTipText("Switch to " + (this.plugin.getConfig().sectionMode() ? "standard mode" : "section mode"));
    }

    private void updatePanelViewMarker() {
        this.panelViewMarker.setCurrentState(this.plugin.getConfig().panelView());
    }

    private void updateSortingMarker() {
        boolean isAlphabeticalMode = this.plugin.getConfig().sortingMode() == InventorySetupsSortingID.ALPHABETICAL;
        this.sortingMarker.setIcon(isAlphabeticalMode ? ALPHABETICAL_ICON : NO_ALPHABETICAL_ICON);
        this.sortingMarker.setToolTipText(isAlphabeticalMode ? "Remove alphabetical sorting" : "Alphabetically sort setups");
    }

    private void setScrollBarPosition(int scrollbarValue) {
        this.validate();
        this.repaint();
        this.contentWrapperPane.getVerticalScrollBar().setValue(scrollbarValue);
    }

    private void layoutSetups(List<InventorySetup> originalFilteredSetups) {
        this.overviewPanel.setLayout(new GridBagLayout());
        this.overviewPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        if (this.plugin.getConfig().sectionMode()) {
            this.layoutSections(originalFilteredSetups, constraints);
        } else if (this.plugin.getConfig().panelView() == InventorySetupsPanelViewID.ICON) {
            JPanel iconGridPanel = InventorySetupsSectionPanel.createIconPanelGrid(this.plugin, this, originalFilteredSetups, 4, null, null, true);
            this.overviewPanel.add((Component)iconGridPanel, constraints);
            ++constraints.gridy;
        } else {
            for (InventorySetup setup : originalFilteredSetups) {
                constraints.fill = 2;
                InventorySetupsPanel newPanel = null;
                newPanel = this.plugin.getConfig().panelView() == InventorySetupsPanelViewID.COMPACT ? new InventorySetupsCompactPanel(this.plugin, this, setup, null) : new InventorySetupsStandardPanel(this.plugin, this, setup, null);
                this.overviewPanel.add((Component)newPanel, constraints);
                ++constraints.gridy;
                this.overviewPanel.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
                ++constraints.gridy;
            }
        }
        this.setupDisplayPanel.setVisible(false);
        if (!this.plugin.getSavedVersionString().equals(this.plugin.getCurrentVersionString())) {
            this.northAnchoredPanel.setVisible(false);
            this.updateNewsPanel.setVisible(true);
            this.overviewPanel.setVisible(false);
            this.noSetupsPanel.setVisible(false);
        } else {
            this.northAnchoredPanel.setVisible(true);
            this.updateNewsPanel.setVisible(false);
            this.noSetupsPanel.setVisible(this.plugin.getInventorySetups().isEmpty() && !this.plugin.getConfig().sectionMode());
            this.overviewPanel.setVisible(!this.plugin.getInventorySetups().isEmpty() || this.plugin.getConfig().sectionMode());
        }
    }

    private void layoutSections(List<InventorySetup> setups, GridBagConstraints constraints) {
        Set<String> setupNamesToBeIncluded = setups.stream().map(InventorySetup::getName).collect(Collectors.toSet());
        for (InventorySetupsSection section : this.plugin.getSections()) {
            Set<String> setupsInSection = this.plugin.getCache().getSectionSetupsMap().get(section.getName()).keySet();
            if (this.sectionShouldBeHidden(setupNamesToBeIncluded, setupsInSection)) continue;
            boolean forceMaximization = !this.searchBar.getText().isEmpty();
            InventorySetupsSectionPanel sectionPanel = new InventorySetupsSectionPanel(this.plugin, this, section, forceMaximization, true, setupNamesToBeIncluded, setupsInSection, setups);
            this.overviewPanel.add((Component)sectionPanel, constraints);
            ++constraints.gridy;
            this.overviewPanel.add(Box.createRigidArea(new Dimension(0, 5)), constraints);
            ++constraints.gridy;
        }
        this.createUnassignedSection(setups, constraints, setupNamesToBeIncluded);
    }

    private void createUnassignedSection(List<InventorySetup> setups, GridBagConstraints constraints, Set<String> setupNamesToBeDisplayed) {
        InventorySetupsSection unassignedSection = new InventorySetupsSection("Unassigned");
        unassignedSection.setMaximized(this.plugin.getBooleanConfigValue("unassignedMaximized"));
        HashSet<String> setupsInSection = new HashSet<String>();
        for (InventorySetup setup : setups) {
            if (this.plugin.getCache().getSetupSectionsMap().get(setup.getName()).size() != 0) continue;
            unassignedSection.getSetups().add(setup.getName());
            setupsInSection.add(setup.getName());
        }
        if (unassignedSection.getSetups().isEmpty() || this.sectionShouldBeHidden(setupNamesToBeDisplayed, setupsInSection)) {
            return;
        }
        boolean forceMaximization = !this.searchBar.getText().isEmpty();
        InventorySetupsSectionPanel sectionPanel = new InventorySetupsSectionPanel(this.plugin, this, unassignedSection, forceMaximization, false, setupNamesToBeDisplayed, setupsInSection, setups);
        this.overviewPanel.add((Component)sectionPanel, constraints);
        ++constraints.gridy;
    }

    public boolean sectionShouldBeHidden(Set<String> setupNamesToBeIncluded, Set<String> setupsInSection) {
        if (!this.searchBar.getText().isEmpty()) {
            HashSet<String> intersection = new HashSet<String>(setupsInSection);
            intersection.retainAll(setupNamesToBeIncluded);
            return intersection.isEmpty();
        }
        return false;
    }

    public InventorySetup getCurrentSelectedSetup() {
        return this.currentSelectedSetup;
    }

    public List<InventorySetup> getFilteredInventorysetups() {
        return this.filteredInventorysetups;
    }

    static {
        BufferedImage helpIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/help_button.png");
        HELP_ICON = new ImageIcon(helpIcon);
        HELP_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)helpIcon, (float)0.53f));
        BufferedImage sectionIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/section_mode_icon.png");
        BufferedImage sectionIconHover = ImageUtil.luminanceOffset((Image)sectionIcon, (int)-150);
        SECTION_VIEW_ICON = new ImageIcon(sectionIcon);
        SECTION_VIEW_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)sectionIcon, (float)0.53f));
        NO_SECTION_VIEW_ICON = new ImageIcon(sectionIconHover);
        NO_SECTION_VIEW_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)sectionIconHover, (int)-100));
        BufferedImage standardIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/standard_mode_icon.png");
        STANDARD_VIEW_ICON = new ImageIcon(standardIcon);
        STANDARD_VIEW_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)standardIcon, (int)-100));
        BufferedImage compactIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/compact_mode_icon.png");
        COMPACT_VIEW_ICON = new ImageIcon(compactIcon);
        COMPACT_VIEW_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)compactIcon, (float)0.53f));
        BufferedImage iconIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/icon_mode_icon.png");
        ICON_VIEW_ICON = new ImageIcon(iconIcon);
        ICON_VIEW_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)iconIcon, (float)0.53f));
        BufferedImage alphabeticalIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/alphabetical_icon.png");
        BufferedImage alphabeticalIconHover = ImageUtil.luminanceOffset((Image)alphabeticalIcon, (int)-150);
        ALPHABETICAL_ICON = new ImageIcon(alphabeticalIcon);
        ALPHABETICAL_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)alphabeticalIcon, (float)0.53f));
        NO_ALPHABETICAL_ICON = new ImageIcon(alphabeticalIconHover);
        NO_ALPHABETICAL_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)alphabeticalIconHover, (int)-100));
        BufferedImage addIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
        BufferedImage importIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/import_icon.png");
        IMPORT_ICON = new ImageIcon(importIcon);
        IMPORT_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)importIcon, (float)0.53f));
        BufferedImage updateIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/update_icon.png");
        UPDATE_ICON = new ImageIcon(updateIcon);
        UPDATE_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)updateIcon, (float)0.53f));
        BufferedImage backIcon = ImageUtil.loadImageResource(InventorySetupsPlugin.class, (String)"/back_arrow_icon.png");
        BACK_ICON = new ImageIcon(backIcon);
        BACK_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)backIcon, (float)0.53f));
        MAIN_TITLE = "Inventory Setups";
    }
}

