/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSection;
import inventorysetups.ui.InventorySetupsMoveHandler;
import inventorysetups.ui.InventorySetupsMoveMenu;
import inventorysetups.ui.InventorySetupsPluginPanel;
import inventorysetups.ui.InventorySetupsSelectionPanel;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class InventorySetupsPanel
extends JPanel
implements InventorySetupsMoveHandler<InventorySetup> {
    protected final InventorySetupsPlugin plugin;
    protected final InventorySetupsPluginPanel panel;
    protected final InventorySetup inventorySetup;
    protected InventorySetupsSection section;
    protected final JPopupMenu popupMenu;

    InventorySetupsPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, InventorySetup invSetup, InventorySetupsSection section) {
        this(plugin, panel, invSetup, section, true);
    }

    InventorySetupsPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, InventorySetup invSetup, InventorySetupsSection section, boolean allowEditable) {
        this.plugin = plugin;
        this.panel = panel;
        this.inventorySetup = invSetup;
        this.section = section;
        this.popupMenu = allowEditable ? new InventorySetupsMoveMenu<InventorySetup>(plugin, panel, this, "Inventory Setup", invSetup) : new JPopupMenu();
        JMenuItem addToSection = new JMenuItem("Add Setup to Sections..");
        this.popupMenu.add(addToSection);
        if (this.section != null && allowEditable) {
            JMenuItem removeFromSection = new JMenuItem("Remove from section");
            removeFromSection.addActionListener(e -> plugin.removeInventorySetupFromSection(invSetup, section));
            this.popupMenu.add(removeFromSection);
        }
        addToSection.addActionListener(e -> {
            if (plugin.getSections().isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)panel), "You must create a section first", "No Sections to Add Setup To", 0);
                return;
            }
            String[] sectionNames = (String[])plugin.getSections().stream().map(InventorySetupsSection::getName).toArray(String[]::new);
            Arrays.sort(sectionNames, String.CASE_INSENSITIVE_ORDER);
            String message = "Select sections to add this setup to";
            String title = "Select Sections";
            InventorySetupsSelectionPanel selectionDialog = new InventorySetupsSelectionPanel((JPanel)((Object)panel), "Select Sections", "Select sections to add this setup to", sectionNames);
            selectionDialog.setOnOk(e1 -> {
                List<String> selectedSections = selectionDialog.getSelectedItems();
                if (!selectedSections.isEmpty()) {
                    plugin.addSetupToSections(invSetup, selectedSections);
                }
            });
            selectionDialog.show();
        });
        this.setComponentPopupMenu(this.popupMenu);
    }

    @Override
    public void moveUp(InventorySetup invSetup) {
        if (this.plugin.getConfig().sectionMode()) {
            int invIndex = this.section.getSetups().indexOf(invSetup.getName());
            this.plugin.moveSetupWithinSection(this.section, invIndex, invIndex - 1);
        } else {
            int invIndex = this.plugin.getInventorySetups().indexOf(invSetup);
            this.plugin.moveSetup(invIndex, invIndex - 1);
        }
    }

    @Override
    public void moveDown(InventorySetup invSetup) {
        if (this.plugin.getConfig().sectionMode()) {
            int invIndex = this.section.getSetups().indexOf(invSetup.getName());
            this.plugin.moveSetupWithinSection(this.section, invIndex, invIndex + 1);
        } else {
            int invIndex = this.plugin.getInventorySetups().indexOf(invSetup);
            this.plugin.moveSetup(invIndex, invIndex + 1);
        }
    }

    @Override
    public void moveToTop(InventorySetup invSetup) {
        if (this.plugin.getConfig().sectionMode()) {
            int invIndex = this.section.getSetups().indexOf(invSetup.getName());
            this.plugin.moveSetupWithinSection(this.section, invIndex, 0);
        } else {
            int invIndex = this.plugin.getInventorySetups().indexOf(invSetup);
            this.plugin.moveSetup(invIndex, 0);
        }
    }

    @Override
    public void moveToBottom(InventorySetup invSetup) {
        if (this.plugin.getConfig().sectionMode()) {
            int invIndex = this.section.getSetups().indexOf(invSetup.getName());
            this.plugin.moveSetupWithinSection(this.section, invIndex, this.section.getSetups().size() - 1);
        } else {
            int invIndex = this.plugin.getInventorySetups().indexOf(invSetup);
            this.plugin.moveSetup(invIndex, this.plugin.getInventorySetups().size() - 1);
        }
    }

    @Override
    public void moveToPosition(InventorySetup invSetup) {
        int invIndex;
        boolean sectionMode;
        int size = sectionMode ? this.section.getSetups().size() : this.plugin.getInventorySetups().size();
        String posDialog = "Enter a position between 1 and " + size + ". Current setup is in position " + ((invIndex = (sectionMode = this.plugin.getConfig().sectionMode()) ? this.section.getSetups().indexOf(invSetup.getName()) : this.plugin.getInventorySetups().indexOf(invSetup)) + 1) + ".";
        String newPositionStr = JOptionPane.showInputDialog((Component)((Object)this.panel), posDialog, "Move Setup", -1);
        if (newPositionStr == null) {
            return;
        }
        try {
            int newPosition = Integer.parseInt(newPositionStr);
            if (newPosition < 1 || newPosition > size) {
                JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid position.", "Move Setup Failed", 0);
                return;
            }
            if (sectionMode) {
                this.plugin.moveSetupWithinSection(this.section, invIndex, newPosition - 1);
            } else {
                this.plugin.moveSetup(invIndex, newPosition - 1);
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid position.", "Move Setup Failed", 0);
        }
    }
}

