/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.ui.InventorySetupsContainerPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsNotesPanel
extends InventorySetupsContainerPanel {
    private JTextArea notesEditor;
    private UndoManager undoRedo;
    private InventorySetup currentInventorySetup;

    InventorySetupsNotesPanel(ItemManager itemManager, InventorySetupsPlugin plugin) {
        super(itemManager, plugin, "Notes");
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.notesEditor = new JTextArea(10, 0);
        this.undoRedo = new UndoManager();
        this.currentInventorySetup = null;
        this.notesEditor.setTabSize(2);
        this.notesEditor.setLineWrap(true);
        this.notesEditor.setWrapStyleWord(true);
        this.notesEditor.setOpaque(false);
        this.undoRedo.setLimit(500);
        this.notesEditor.getDocument().addUndoableEditListener(e -> this.undoRedo.addEdit(e.getEdit()));
        this.notesEditor.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.notesEditor.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.notesEditor.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (InventorySetupsNotesPanel.this.undoRedo.canUndo()) {
                        InventorySetupsNotesPanel.this.undoRedo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.notesEditor.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (InventorySetupsNotesPanel.this.undoRedo.canRedo()) {
                        InventorySetupsNotesPanel.this.undoRedo.redo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.notesEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.notesChanged(InventorySetupsNotesPanel.this.getNotes());
            }

            private void notesChanged(String data) {
                InventorySetupsNotesPanel.this.plugin.updateNotesInSetup(InventorySetupsNotesPanel.this.currentInventorySetup, data);
            }
        });
        int width = 187;
        containerSlotsPanel.setLayout(new BorderLayout());
        containerSlotsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        containerSlotsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.notesEditor.setSize(new Dimension(width, 200));
        containerSlotsPanel.add(this.notesEditor);
    }

    @Override
    public void highlightSlots(List<InventorySetupsItem> currContainer, InventorySetup inventorySetup) {
    }

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        DefaultCaret caret = (DefaultCaret)this.notesEditor.getCaret();
        caret.setUpdatePolicy(1);
        this.notesEditor.setText(setup.getNotes());
        caret.setUpdatePolicy(2);
        this.currentInventorySetup = setup;
    }

    @Override
    public void resetSlotColors() {
    }

    public String getNotes() {
        try {
            Document doc = this.notesEditor.getDocument();
            return this.notesEditor.getDocument().getText(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "getNotes() Failed";
        }
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return false;
    }

    public void setCurrentInventorySetup(InventorySetup currentInventorySetup) {
        this.currentInventorySetup = currentInventorySetup;
    }
}

