/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetupsDisplayAttributes;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsValidName;
import inventorysetups.ui.InventorySetupsPluginPanel;
import inventorysetups.ui.InventorySetupsStandardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.components.FlatTextField;

public class InventorySetupsNameActions<T extends InventorySetupsDisplayAttributes>
extends JPanel {
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    public final T datum;
    private final JLabel save = new JLabel("Save");
    private final JLabel cancel = new JLabel("Cancel");
    private final JLabel edit = new JLabel("Edit");
    private final JLabel displayColorIndicator = new JLabel();
    private final FlatTextField nameInput = new FlatTextField();
    private final InventorySetupsValidName validNameImplementer;

    public InventorySetupsNameActions(T datum, final InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, final InventorySetupsValidName validNameImplementer, JPopupMenu movePopupMenu, final int maxLength, Color panelColor, boolean allowEditable, final MouseAdapter flatTextFieldMouseAdapter) {
        Color currentDisplayColor;
        this.setLayout(new BorderLayout());
        this.datum = datum;
        this.validNameImplementer = validNameImplementer;
        this.setBackground(panelColor);
        if (datum.getDisplayColor() == null) {
            this.setBorder(NAME_BOTTOM_BORDER);
            currentDisplayColor = null;
        } else {
            this.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, datum.getDisplayColor()), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR)));
            currentDisplayColor = datum.getDisplayColor();
        }
        JPanel nameActions = new JPanel(new BorderLayout(3, 0));
        nameActions.setBorder(new EmptyBorder(0, 0, 0, 8));
        nameActions.setBackground(panelColor);
        AbstractDocument doc = (AbstractDocument)this.nameInput.getDocument();
        doc.setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet a) throws BadLocationException {
                if (fb.getDocument().getLength() + str.length() <= maxLength) {
                    super.insertString(fb, offset, str, a);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet a) throws BadLocationException {
                if (fb.getDocument().getLength() + str.length() - length >= maxLength) {
                    int chars_available = maxLength - (fb.getDocument().getLength() - length);
                    int chars_to_cut = str.length() - chars_available;
                    str = str.substring(0, str.length() - chars_to_cut);
                }
                super.replace(fb, offset, length, str, a);
            }
        });
        this.nameInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InventorySetupsNameActions.this.updateSaveButtonDuringEditing();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InventorySetupsNameActions.this.updateSaveButtonDuringEditing();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InventorySetupsNameActions.this.updateSaveButtonDuringEditing();
            }
        });
        this.nameInput.getTextField().addMouseListener(flatTextFieldMouseAdapter);
        this.save.setVisible(false);
        this.save.setFont(FontManager.getRunescapeSmallFont());
        this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.save.setBackground(panelColor);
        this.save.addMouseListener(new MouseAdapter((InventorySetupsDisplayAttributes)datum, plugin, panel){
            final /* synthetic */ InventorySetupsDisplayAttributes val$datum;
            final /* synthetic */ InventorySetupsPlugin val$plugin;
            final /* synthetic */ InventorySetupsPluginPanel val$panel;
            {
                this.val$datum = inventorySetupsDisplayAttributes;
                this.val$plugin = inventorySetupsPlugin;
                this.val$panel = inventorySetupsPluginPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && InventorySetupsNameActions.this.save.isEnabled()) {
                    Color currentDisplayColor;
                    InventorySetupsNameActions.this.nameInput.getTextField().addMouseListener(flatTextFieldMouseAdapter);
                    validNameImplementer.updateName(InventorySetupsNameActions.this.nameInput.getText());
                    Color newDisplayColor = null;
                    if (InventorySetupsNameActions.this.displayColorIndicator.getBorder() != null && (currentDisplayColor = ((MatteBorder)((CompoundBorder)InventorySetupsNameActions.this.displayColorIndicator.getBorder()).getInsideBorder()).getMatteColor()) != JagexColors.MENU_TARGET) {
                        newDisplayColor = currentDisplayColor;
                    }
                    this.val$datum.setDisplayColor(newDisplayColor);
                    this.val$plugin.getDataManager().updateConfig(true, true);
                    InventorySetupsNameActions.this.nameInput.setEditable(false);
                    InventorySetupsNameActions.this.updateNameActions(false);
                    InventorySetupsNameActions.this.requestFocusInWindow();
                    this.val$panel.redrawOverviewPanel(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (validNameImplementer.isNameValid(InventorySetupsNameActions.this.nameInput.getText())) {
                    InventorySetupsNameActions.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR.darker());
                } else {
                    InventorySetupsNameActions.this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (validNameImplementer.isNameValid(InventorySetupsNameActions.this.nameInput.getText())) {
                    InventorySetupsNameActions.this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
                } else {
                    InventorySetupsNameActions.this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
                }
            }
        });
        this.cancel.setVisible(false);
        this.cancel.setFont(FontManager.getRunescapeSmallFont());
        this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.cancel.setBackground(panelColor);
        this.cancel.addMouseListener(new MouseAdapter((InventorySetupsDisplayAttributes)datum, currentDisplayColor){
            final /* synthetic */ InventorySetupsDisplayAttributes val$datum;
            final /* synthetic */ Color val$currentDisplayColor;
            {
                this.val$datum = inventorySetupsDisplayAttributes;
                this.val$currentDisplayColor = color;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    InventorySetupsNameActions.this.nameInput.getTextField().addMouseListener(flatTextFieldMouseAdapter);
                    InventorySetupsNameActions.this.nameInput.setEditable(false);
                    InventorySetupsNameActions.this.nameInput.setText(this.val$datum.getName());
                    InventorySetupsNameActions.this.nameInput.getTextField().setCaretPosition(0);
                    InventorySetupsNameActions.this.updateNameActions(false);
                    InventorySetupsNameActions.this.requestFocusInWindow();
                    InventorySetupsNameActions.this.updateDisplayColorLabel(this.val$currentDisplayColor);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.cancel.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
            }
        });
        this.edit.setFont(FontManager.getRunescapeSmallFont());
        this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.edit.setBackground(panelColor);
        this.edit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    InventorySetupsNameActions.this.nameInput.getTextField().removeMouseListener(flatTextFieldMouseAdapter);
                    InventorySetupsNameActions.this.nameInput.setEditable(true);
                    InventorySetupsNameActions.this.updateNameActions(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.edit.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameActions.add((Component)this.save, "East");
        nameActions.add((Component)this.cancel, "West");
        nameActions.add((Component)this.edit, "Center");
        this.nameInput.setText(datum.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(panelColor);
        this.nameInput.setPreferredSize(new Dimension(0, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBackground(panelColor);
        this.nameInput.getTextField().setBorder(new EmptyBorder(0, 6, 0, 0));
        if (allowEditable) {
            this.nameInput.getTextField().setComponentPopupMenu(movePopupMenu);
        }
        this.nameInput.getTextField().setCaretPosition(0);
        this.displayColorIndicator.setToolTipText("Edit the color of the name");
        this.displayColorIndicator.setIcon(InventorySetupsStandardPanel.DISPLAY_COLOR_ICON);
        this.displayColorIndicator.setBackground(panelColor);
        this.displayColorIndicator.setVisible(false);
        JPopupMenu displayColorMenu = new JPopupMenu();
        JMenuItem removeColor = new JMenuItem("Remove the color of the name");
        displayColorMenu.add(removeColor);
        removeColor.addActionListener(e -> this.updateDisplayColorLabel(null));
        this.displayColorIndicator.setComponentPopupMenu(displayColorMenu);
        this.updateDisplayColorLabel(currentDisplayColor);
        this.displayColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    plugin.openColorPicker("Choose a Display color", currentDisplayColor == null ? JagexColors.MENU_TARGET : currentDisplayColor, c -> InventorySetupsNameActions.this.updateDisplayColorLabel((Color)c));
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.displayColorIndicator.setIcon(InventorySetupsStandardPanel.DISPLAY_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsNameActions.this.displayColorIndicator.setIcon(InventorySetupsStandardPanel.DISPLAY_COLOR_ICON);
            }
        });
        JPanel wrapper = new JPanel();
        wrapper.setBackground(panelColor);
        wrapper.setLayout(new BorderLayout());
        wrapper.add((Component)this.nameInput, "Center");
        wrapper.add((Component)this.displayColorIndicator, "West");
        if (allowEditable) {
            wrapper.add((Component)nameActions, "East");
        }
        this.add((Component)wrapper, "Center");
    }

    private void updateNameActions(boolean saveAndCancel) {
        this.save.setVisible(saveAndCancel);
        this.cancel.setVisible(saveAndCancel);
        this.edit.setVisible(!saveAndCancel);
        this.displayColorIndicator.setVisible(saveAndCancel);
        if (saveAndCancel) {
            this.nameInput.getTextField().requestFocusInWindow();
            this.nameInput.getTextField().selectAll();
        }
    }

    private void updateDisplayColorLabel(Color color) {
        this.displayColorIndicator.setBorder(new CompoundBorder(new EmptyBorder(0, 4, 0, 0), new MatteBorder(0, 0, 3, 0, color)));
        this.updateSaveButtonDuringEditing();
    }

    private void updateSaveButtonDuringEditing() {
        Color newDisplayColor = null;
        if (this.displayColorIndicator.getBorder() != null) {
            newDisplayColor = ((MatteBorder)((CompoundBorder)this.displayColorIndicator.getBorder()).getInsideBorder()).getMatteColor();
        }
        if (this.datum.getDisplayColor() == newDisplayColor && !this.validNameImplementer.isNameValid(this.nameInput.getText())) {
            this.save.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            this.save.setEnabled(false);
        } else {
            this.save.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
            this.save.setEnabled(true);
        }
    }

    public FlatTextField getNameInput() {
        return this.nameInput;
    }
}

