/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSortingID;
import inventorysetups.ui.InventorySetupsMoveHandler;
import inventorysetups.ui.InventorySetupsPluginPanel;
import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class InventorySetupsMoveMenu<T>
extends JPopupMenu {
    private final InventorySetupsPluginPanel panel;
    private final InventorySetupsPlugin plugin;

    public InventorySetupsMoveMenu(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, InventorySetupsMoveHandler<T> moveHandler, String type, T datum) {
        this.panel = panel;
        this.plugin = plugin;
        JMenuItem moveUp = new JMenuItem("Move " + type + " Up");
        JMenuItem moveDown = new JMenuItem("Move " + type + " Down");
        JMenuItem moveToTop = new JMenuItem("Move " + type + " to Top");
        JMenuItem moveToBottom = new JMenuItem("Move " + type + " to Bottom");
        JMenuItem moveToPosition = new JMenuItem("Move " + type + " to Position..");
        this.add(moveUp);
        this.add(moveDown);
        this.add(moveToTop);
        this.add(moveToBottom);
        this.add(moveToPosition);
        moveUp.addActionListener(e -> {
            if (!this.checkSortingMode()) {
                return;
            }
            moveHandler.moveUp(datum);
        });
        moveDown.addActionListener(e -> {
            if (!this.checkSortingMode()) {
                return;
            }
            moveHandler.moveDown(datum);
        });
        moveToTop.addActionListener(e -> {
            if (!this.checkSortingMode()) {
                return;
            }
            moveHandler.moveToTop(datum);
        });
        moveToBottom.addActionListener(e -> {
            if (!this.checkSortingMode()) {
                return;
            }
            moveHandler.moveToBottom(datum);
        });
        moveToPosition.addActionListener(e -> {
            if (!this.checkSortingMode()) {
                return;
            }
            moveHandler.moveToPosition(datum);
        });
    }

    private boolean checkSortingMode() {
        if (this.plugin.getConfig().sortingMode() != InventorySetupsSortingID.DEFAULT) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You cannot move this while a sorting mode is enabled.", "Move Failed", 0);
            return false;
        }
        return true;
    }
}

