/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsRunePouchType;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.InventorySetupsVariationMapping;
import inventorysetups.ui.InventorySetupsBoltPouchPanel;
import inventorysetups.ui.InventorySetupsContainerPanel;
import inventorysetups.ui.InventorySetupsRunePouchPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsInventoryPanel
extends InventorySetupsContainerPanel {
    private static final int ITEMS_PER_ROW = 4;
    private static final int NUM_INVENTORY_ITEMS = 28;
    private List<InventorySetupsSlot> inventorySlots;
    private final InventorySetupsRunePouchPanel runePouchPanel;
    private final InventorySetupsBoltPouchPanel boltPouchPanel;

    InventorySetupsInventoryPanel(ItemManager itemManager, InventorySetupsPlugin plugin, InventorySetupsRunePouchPanel runePouchPanel, InventorySetupsBoltPouchPanel boltPouchPanel) {
        super(itemManager, plugin, "Inventory");
        this.runePouchPanel = runePouchPanel;
        this.boltPouchPanel = boltPouchPanel;
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.inventorySlots = new ArrayList<InventorySetupsSlot>();
        for (int i = 0; i < 28; ++i) {
            this.inventorySlots.add(new InventorySetupsSlot(ColorScheme.DARKER_GRAY_COLOR, InventorySetupsSlotID.INVENTORY, i));
        }
        int numRows = 7;
        containerSlotsPanel.setLayout(new GridLayout(numRows, 4, 1, 1));
        for (int i = 0; i < 28; ++i) {
            containerSlotsPanel.add(this.inventorySlots.get(i));
            super.addFuzzyMouseListenerToSlot(this.inventorySlots.get(i));
            super.addStackMouseListenerToSlot(this.inventorySlots.get(i));
            super.addUpdateFromContainerMouseListenerToSlot(this.inventorySlots.get(i));
            super.addUpdateFromSearchMouseListenerToSlot(this.inventorySlots.get(i), true);
            super.addRemoveMouseListenerToSlot(this.inventorySlots.get(i));
            super.addUpdateFromContainerToAllInstancesMouseListenerToSlot(this.inventorySlots.get(i));
            super.addUpdateFromSearchToAllInstancesMouseListenerToSlot(this.inventorySlots.get(i), true);
        }
    }

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        for (int i = 0; i < 28; ++i) {
            super.setSlotImageAndText(this.inventorySlots.get(i), setup, setup.getInventory().get(i));
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void highlightSlots(List<InventorySetupsItem> currInventory, InventorySetup inventorySetup) {
        List<InventorySetupsItem> inventoryToCheck = inventorySetup.getInventory();
        assert (currInventory.size() == inventoryToCheck.size()) : "size mismatch";
        this.isHighlighted = true;
        if (inventorySetup.isUnorderedHighlight()) {
            this.doUnorderedHighlighting(currInventory, inventorySetup);
            return;
        }
        InventorySetupsRunePouchType rpType = InventorySetupsRunePouchType.NONE;
        boolean currInvHasBoltPouch = false;
        for (int i = 0; i < 28; ++i) {
            InventorySetupsItem currInvItem = currInventory.get(i);
            if (rpType == InventorySetupsRunePouchType.NONE) {
                rpType = this.plugin.getRunePouchType(currInvItem.getId());
            }
            if (!currInvHasBoltPouch && this.plugin.isItemBoltPouch(currInvItem.getId())) {
                currInvHasBoltPouch = true;
            }
            super.highlightSlot(inventorySetup, inventoryToCheck.get(i), currInventory.get(i), this.inventorySlots.get(i));
        }
        InventorySetupsRunePouchType rpTypeFinal = rpType;
        this.plugin.getClientThread().invokeLater(() -> this.handleRunePouchHighlighting(inventorySetup, rpTypeFinal));
        boolean currInvHasBoltPouchFinal = currInvHasBoltPouch;
        this.plugin.getClientThread().invokeLater(() -> this.handleBoltPouchHighlighting(inventorySetup, currInvHasBoltPouchFinal));
    }

    @Override
    public void resetSlotColors() {
        if (!this.isHighlighted) {
            return;
        }
        for (InventorySetupsSlot inventorySlot : this.inventorySlots) {
            inventorySlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
        this.runePouchPanel.resetSlotColors();
        this.boltPouchPanel.resetSlotColors();
        this.isHighlighted = false;
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return true;
    }

    private void doUnorderedHighlighting(List<InventorySetupsItem> currInventory, InventorySetup inventorySetup) {
        HashMap<Integer, List<Integer>> currentInventoryMapping = new HashMap<Integer, List<Integer>>();
        InventorySetupsRunePouchType runePouchType = InventorySetupsRunePouchType.NONE;
        boolean currInvHasBoltPouch = false;
        for (InventorySetupsItem item : currInventory) {
            ArrayList<Integer> currentItemList;
            if (runePouchType == InventorySetupsRunePouchType.NONE) {
                runePouchType = this.plugin.getRunePouchType(item.getId());
            }
            if (!currInvHasBoltPouch && this.plugin.isItemBoltPouch(item.getId())) {
                currInvHasBoltPouch = true;
            }
            if ((currentItemList = (ArrayList<Integer>)currentInventoryMapping.get(item.getId())) == null) {
                currentItemList = new ArrayList<Integer>();
                currentInventoryMapping.put(item.getId(), currentItemList);
            }
            currentItemList.add(item.getQuantity());
        }
        List<InventorySetupsItem> setupInventory = inventorySetup.getInventory();
        ArrayList<Boolean> processedInventoryItems = new ArrayList<Boolean>(Arrays.asList(new Boolean[setupInventory.size()]));
        Collections.fill(processedInventoryItems, Boolean.FALSE);
        this.processExactItems(inventorySetup, currentInventoryMapping, processedInventoryItems, false);
        this.processExactItems(inventorySetup, currentInventoryMapping, processedInventoryItems, true);
        for (int i = 0; i < setupInventory.size(); ++i) {
            if (((Boolean)processedInventoryItems.get(i)).booleanValue()) continue;
            InventorySetupsItem savedItemFromInventory = setupInventory.get(i);
            int savedItemId = savedItemFromInventory.getId();
            List currentItemListForSpecificId = (List)currentInventoryMapping.get(savedItemId);
            if (currentItemListForSpecificId == null && savedItemFromInventory.isFuzzy()) {
                Iterator iterator = currentInventoryMapping.keySet().iterator();
                while (iterator.hasNext()) {
                    int currentItemIdFromMapping = (Integer)iterator.next();
                    if (InventorySetupsVariationMapping.map(currentItemIdFromMapping) != InventorySetupsVariationMapping.map(savedItemId)) continue;
                    currentItemListForSpecificId = (List)currentInventoryMapping.get(currentItemIdFromMapping);
                    savedItemId = currentItemIdFromMapping;
                    break;
                }
            }
            if (currentItemListForSpecificId == null) {
                this.inventorySlots.get(i).setBackground(inventorySetup.getHighlightColor());
                continue;
            }
            this.updateCurrentUnorderedSlot(savedItemId, inventorySetup, this.inventorySlots.get(i), savedItemFromInventory, currentItemListForSpecificId, currentInventoryMapping);
        }
        InventorySetupsRunePouchType rpTypeFinal = runePouchType;
        this.plugin.getClientThread().invokeLater(() -> this.handleRunePouchHighlighting(inventorySetup, rpTypeFinal));
        boolean currInvHasBoltPouchFinal = currInvHasBoltPouch;
        this.plugin.getClientThread().invokeLater(() -> this.handleBoltPouchHighlighting(inventorySetup, currInvHasBoltPouchFinal));
    }

    private void processExactItems(InventorySetup inventorySetup, Map<Integer, List<Integer>> currentInventoryMapping, List<Boolean> processedInvItems, boolean allowFuzzy) {
        List<InventorySetupsItem> setupInventory = inventorySetup.getInventory();
        for (int i = 0; i < setupInventory.size(); ++i) {
            if (processedInvItems.get(i).booleanValue()) continue;
            InventorySetupsItem savedItemFromInventory = setupInventory.get(i);
            if (savedItemFromInventory.getId() == -1) {
                this.inventorySlots.get(i).setBackground(ColorScheme.DARKER_GRAY_COLOR);
                processedInvItems.set(i, Boolean.TRUE);
                continue;
            }
            List<Integer> currentItemListForSpecificId = currentInventoryMapping.get(savedItemFromInventory.getId());
            if (currentItemListForSpecificId == null || !allowFuzzy && savedItemFromInventory.isFuzzy()) continue;
            this.updateCurrentUnorderedSlot(savedItemFromInventory.getId(), inventorySetup, this.inventorySlots.get(i), savedItemFromInventory, currentItemListForSpecificId, currentInventoryMapping);
            processedInvItems.set(i, Boolean.TRUE);
        }
    }

    private void updateCurrentUnorderedSlot(int itemId, InventorySetup inventorySetup, InventorySetupsSlot currentSlot, InventorySetupsItem savedItemFromInventory, List<Integer> currentItemListForSpecificId, Map<Integer, List<Integer>> currentInventoryMapping) {
        Integer currentInventoryItemQty = currentItemListForSpecificId.get(currentItemListForSpecificId.size() - 1);
        currentItemListForSpecificId.remove(currentItemListForSpecificId.size() - 1);
        if (currentItemListForSpecificId.isEmpty()) {
            currentInventoryMapping.remove(itemId);
        }
        if (this.shouldHighlightSlotBasedOnStack(savedItemFromInventory.getStackCompare(), savedItemFromInventory.getQuantity(), currentInventoryItemQty)) {
            currentSlot.setBackground(inventorySetup.getHighlightColor());
        } else {
            currentSlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
    }

    private void handleRunePouchHighlighting(InventorySetup inventorySetup, InventorySetupsRunePouchType runePouchType) {
        if (inventorySetup.getRune_pouch() != null) {
            if (runePouchType != InventorySetupsRunePouchType.NONE) {
                List<InventorySetupsItem> runePouchToCheck = this.plugin.getRunePouchData(runePouchType);
                this.runePouchPanel.highlightSlots(runePouchToCheck, inventorySetup);
            } else {
                this.runePouchPanel.highlightAllSlots(inventorySetup);
            }
        } else {
            this.runePouchPanel.resetSlotColors();
        }
    }

    private void handleBoltPouchHighlighting(InventorySetup inventorySetup, boolean doesCurrentInventoryHaveBoltPouch) {
        if (inventorySetup.getBoltPouch() != null) {
            if (doesCurrentInventoryHaveBoltPouch) {
                List<InventorySetupsItem> boltPouchToCheck = this.plugin.getBoltPouchData();
                this.boltPouchPanel.highlightSlots(boltPouchToCheck, inventorySetup);
            } else {
                this.boltPouchPanel.highlightAllSlots(inventorySetup);
            }
        } else {
            this.boltPouchPanel.resetSlotColors();
        }
    }
}

