/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSection;
import inventorysetups.ui.InventorySetupsPanel;
import inventorysetups.ui.InventorySetupsPluginPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;

public class InventorySetupsIconPanel
extends InventorySetupsPanel {
    InventorySetupsIconPanel(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, InventorySetup invSetup, InventorySetupsSection section) {
        this(plugin, panel, invSetup, section, true);
    }

    InventorySetupsIconPanel(InventorySetupsPlugin plugin, final InventorySetupsPluginPanel panel, final InventorySetup invSetup, InventorySetupsSection section, boolean allowEditable) {
        super(plugin, panel, invSetup, section, allowEditable);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setPreferredSize(new Dimension(46, 42));
        JLabel imageLabel = new JLabel();
        imageLabel.setHorizontalAlignment(0);
        imageLabel.setVerticalAlignment(0);
        int itemIDForImage = invSetup.getIconID();
        if (itemIDForImage <= 0 && (itemIDForImage = invSetup.getEquipment().get(EquipmentInventorySlot.WEAPON.getSlotIdx()).getId()) <= 0) {
            itemIDForImage = 7542;
        }
        this.add((Component)imageLabel, "Center");
        AsyncBufferedImage itemImg = plugin.getItemManager().getImage(itemIDForImage, 1, false);
        Runnable r = () -> {
            imageLabel.setIcon(new ImageIcon((Image)itemImg));
            this.repaint();
        };
        itemImg.onLoaded(r);
        r.run();
        imageLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setToolTipText(invSetup.getName());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    panel.setCurrentInventorySetup(invSetup, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InventorySetupsIconPanel.this.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InventorySetupsIconPanel.this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            }
        });
        JMenuItem updateIcon = new JMenuItem("Update Icon..");
        updateIcon.addActionListener(e -> plugin.updateInventorySetupIcon(invSetup));
        this.popupMenu.add(updateIcon);
    }
}

