/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.ui.InventorySetupsContainerPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsEquipmentPanel
extends InventorySetupsContainerPanel {
    private Map<EquipmentInventorySlot, InventorySetupsSlot> equipmentSlots;

    InventorySetupsEquipmentPanel(ItemManager itemManager, InventorySetupsPlugin plugin) {
        super(itemManager, plugin, "Equipment");
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.equipmentSlots = new HashMap<EquipmentInventorySlot, InventorySetupsSlot>();
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            InventorySetupsSlot setupSlot = new InventorySetupsSlot(ColorScheme.DARKER_GRAY_COLOR, InventorySetupsSlotID.EQUIPMENT, slot.getSlotIdx());
            super.addFuzzyMouseListenerToSlot(setupSlot);
            if (slot == EquipmentInventorySlot.AMMO || slot == EquipmentInventorySlot.WEAPON) {
                super.addStackMouseListenerToSlot(setupSlot);
            }
            super.addUpdateFromContainerMouseListenerToSlot(setupSlot);
            super.addUpdateFromSearchMouseListenerToSlot(setupSlot, true);
            super.addRemoveMouseListenerToSlot(setupSlot);
            super.addUpdateFromContainerToAllInstancesMouseListenerToSlot(setupSlot);
            super.addUpdateFromSearchToAllInstancesMouseListenerToSlot(setupSlot, true);
            this.equipmentSlots.put(slot, setupSlot);
        }
        GridLayout gridLayout = new GridLayout(5, 3, 1, 1);
        containerSlotsPanel.setLayout(gridLayout);
        containerSlotsPanel.add(new InventorySetupsSlot(ColorScheme.DARK_GRAY_COLOR, InventorySetupsSlotID.EQUIPMENT, -1));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.HEAD));
        containerSlotsPanel.add(new InventorySetupsSlot(ColorScheme.DARK_GRAY_COLOR, InventorySetupsSlotID.EQUIPMENT, -1));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.CAPE));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.AMULET));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.AMMO));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.WEAPON));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.BODY));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.SHIELD));
        containerSlotsPanel.add(new InventorySetupsSlot(ColorScheme.DARK_GRAY_COLOR, InventorySetupsSlotID.EQUIPMENT, -1));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.LEGS));
        containerSlotsPanel.add(new InventorySetupsSlot(ColorScheme.DARK_GRAY_COLOR, InventorySetupsSlotID.EQUIPMENT, -1));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.GLOVES));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.BOOTS));
        containerSlotsPanel.add(this.equipmentSlots.get(EquipmentInventorySlot.RING));
    }

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            int i = slot.getSlotIdx();
            super.setSlotImageAndText(this.equipmentSlots.get(slot), setup, setup.getEquipment().get(i));
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void highlightSlots(List<InventorySetupsItem> currentEquipment, InventorySetup inventorySetup) {
        List<InventorySetupsItem> savedEquipmentFromSetup = inventorySetup.getEquipment();
        assert (currentEquipment.size() == savedEquipmentFromSetup.size()) : "size mismatch";
        this.isHighlighted = true;
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            int slotIdx = slot.getSlotIdx();
            super.highlightSlot(inventorySetup, savedEquipmentFromSetup.get(slotIdx), currentEquipment.get(slotIdx), this.equipmentSlots.get(slot));
        }
    }

    @Override
    public void resetSlotColors() {
        if (!this.isHighlighted) {
            return;
        }
        for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
            this.equipmentSlots.get(slot).setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
        this.isHighlighted = false;
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return id == EquipmentInventorySlot.AMMO.getSlotIdx() || id == EquipmentInventorySlot.WEAPON.getSlotIdx();
    }
}

